/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.pagination.LayoutMasterSet;
import org.apache.fop.fo.pagination.PageSequenceMaster;
import org.apache.fop.fo.pagination.SimplePageMaster;
import org.apache.fop.fo.pagination.SubSequenceSpecifier;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.layoutmgr.BlockLevelEventProducer;
import org.xml.sax.Locator;

public class RepeatablePageMasterReference
extends FObj
implements SubSequenceSpecifier {
    private String masterReference;
    private SimplePageMaster master;
    private Property maximumRepeats;
    private static final int INFINITE = -1;
    private int numberConsumed;

    public RepeatablePageMasterReference(FONode parent) {
        super(parent);
    }

    @Override
    public void bind(PropertyList pList) throws FOPException {
        this.masterReference = pList.get(154).getString();
        this.maximumRepeats = pList.get(156);
        if (this.masterReference == null || this.masterReference.equals("")) {
            this.missingPropertyError("master-reference");
        }
    }

    @Override
    public void startOfNode() throws FOPException {
        PageSequenceMaster pageSequenceMaster = (PageSequenceMaster)this.parent;
        if (this.masterReference == null) {
            this.missingPropertyError("master-reference");
        } else {
            pageSequenceMaster.addSubsequenceSpecifier(this);
        }
    }

    @Override
    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        this.invalidChildError(loc, nsURI, localName);
    }

    @Override
    public SimplePageMaster getNextPageMaster(boolean isOddPage, boolean isFirstPage, boolean isLastPage, boolean isEmptyPage, boolean skipPagePositionOnly) {
        if (this.getMaximumRepeats() != -1 && this.numberConsumed >= this.getMaximumRepeats()) {
            return null;
        }
        ++this.numberConsumed;
        return this.master;
    }

    @Override
    public SimplePageMaster getLastPageMaster(boolean isOddPage, boolean isFirstPage, boolean isEmptyPage, BlockLevelEventProducer blockLevelEventProducer) {
        return this.getNextPageMaster(isOddPage, isFirstPage, true, isEmptyPage, false);
    }

    public int getMaximumRepeats() {
        if (this.maximumRepeats.getEnum() == 89) {
            return -1;
        }
        int mr = this.maximumRepeats.getNumeric().getValue();
        if (mr < 0) {
            log.debug("negative maximum-repeats: " + this.maximumRepeats);
            mr = 0;
        }
        return mr;
    }

    @Override
    public void reset() {
        this.numberConsumed = 0;
    }

    @Override
    public boolean goToPrevious() {
        if (this.numberConsumed == 0) {
            return false;
        }
        --this.numberConsumed;
        return true;
    }

    @Override
    public boolean hasPagePositionLast() {
        return false;
    }

    @Override
    public boolean hasPagePositionOnly() {
        return false;
    }

    @Override
    public String getLocalName() {
        return "repeatable-page-master-reference";
    }

    @Override
    public int getNameId() {
        return 63;
    }

    @Override
    public void resolveReferences(LayoutMasterSet layoutMasterSet) throws ValidationException {
        this.master = layoutMasterSet.getSimplePageMaster(this.masterReference);
        if (this.master == null) {
            BlockLevelEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster()).noMatchingPageMaster(this, this.parent.getName(), this.masterReference, this.getLocator());
        }
    }

    @Override
    public boolean canProcess(String flowName) {
        assert (this.master != null);
        return this.master.getRegion(58).getRegionName().equals(flowName);
    }

    @Override
    public boolean isInfinite() {
        return this.getMaximumRepeats() == -1;
    }

    @Override
    public boolean isReusable() {
        return false;
    }
}

