/*
 * Decompiled with CFR 0.152.
 */
package mlsub.typing.lowlevel;

import mlsub.typing.lowlevel.BitVector;
import mlsub.typing.lowlevel.LowlevelUnsatisfiable;

final class Domain
extends BitVector {
    private boolean containsUnit;
    static final int UP = 0;
    static final int DOWN = 1;
    int cardUp = Integer.MAX_VALUE;
    int cardDown = Integer.MAX_VALUE;

    public Domain(int width) {
        super(width);
        this.fill(width);
        this.containsUnit = true;
        this.cardUp = width;
        this.cardDown = width;
    }

    public Domain(Domain old) {
        super(old);
        this.containsUnit = old.containsUnit;
        this.cardUp = old.cardUp;
        this.cardDown = old.cardDown;
    }

    int cardinal() {
        if (this.containsUnit) {
            return super.bitCount() + 1;
        }
        return super.bitCount();
    }

    public boolean isEmpty() {
        return !this.containsUnit && super.isEmpty();
    }

    public boolean containsUnit() {
        return this.containsUnit;
    }

    public boolean needPropagation(int direction) {
        int card = this.cardinal();
        switch (direction) {
            case 0: {
                if (card >= this.cardUp) break;
                this.cardUp = card;
                return true;
            }
            case 1: {
                if (card >= this.cardDown) break;
                this.cardDown = card;
                return true;
            }
        }
        return false;
    }

    void initGfpCardinals() {
        this.cardUp = Integer.MAX_VALUE;
        this.cardDown = Integer.MAX_VALUE;
    }

    public void reduce(boolean unit, BitVector set) throws LowlevelUnsatisfiable {
        this.and(set);
        this.containsUnit &= unit;
        if (this.isEmpty()) {
            throw LowlevelUnsatisfiable.instance;
        }
    }

    public void exclude(BitVector set) throws LowlevelUnsatisfiable {
        this.andNot(set);
        if (this.isEmpty()) {
            throw LowlevelUnsatisfiable.instance;
        }
    }

    void rawExcludeUnit() {
        this.containsUnit = false;
    }

    public void excludeUnit() throws LowlevelUnsatisfiable {
        this.containsUnit = false;
        if (this.isEmpty()) {
            throw LowlevelUnsatisfiable.instance;
        }
    }

    public void exclude(int value) throws LowlevelUnsatisfiable {
        if (value == -1) {
            this.containsUnit = false;
        } else {
            super.clear(value);
        }
        if (this.isEmpty()) {
            throw LowlevelUnsatisfiable.instance;
        }
    }

    public int chooseValue() throws LowlevelUnsatisfiable {
        return this.chooseValue(true, null);
    }

    public int chooseValue(boolean unit, BitVector set) throws LowlevelUnsatisfiable {
        int res;
        int n = res = set == null ? this.getLowestSetBit() : this.getLowestSetBitAnd(set);
        if (res != Integer.MIN_VALUE) {
            return res;
        }
        if (unit && this.containsUnit()) {
            return -1;
        }
        throw LowlevelUnsatisfiable.instance;
    }

    public boolean containsValue(int value) {
        if (value == -1) {
            return this.containsUnit;
        }
        return super.get(value);
    }

    public void instantiate(int value) throws LowlevelUnsatisfiable {
        if (!this.containsValue(value)) {
            throw LowlevelUnsatisfiable.instance;
        }
        this.clearAll();
        this.containsUnit = false;
        if (value == -1) {
            this.containsUnit = true;
        } else {
            this.set(value);
        }
    }

    public boolean intersect(BitVector set) {
        return this.getLowestSetBitAnd(set) != Integer.MIN_VALUE;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        if (this.containsUnit) {
            sb.append("+{-1}");
        }
        return sb.toString();
    }

    int getFirstBit() {
        int result = super.getLowestSetBit();
        if (result == Integer.MIN_VALUE && this.containsUnit) {
            result = -1;
        }
        return result;
    }

    public int getNextBit(int i) {
        int result;
        if (i >= 0) {
            result = super.getNextBit(i);
            if (result == Integer.MIN_VALUE && this.containsUnit) {
                result = -1;
            }
        } else {
            result = Integer.MIN_VALUE;
        }
        return result;
    }
}

