/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.assemble;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Archive;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.ArchiveAssembler;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.util.Errors;
import org.jreleaser.util.PlatformUtils;

public final class ArchiveAssemblerResolver {
    private ArchiveAssemblerResolver() {
    }

    public static void resolveArchiveOutputs(JReleaserContext context, Errors errors) {
        List<ArchiveAssembler> activeArchives = context.getModel().getAssemble().getActiveArchives();
        if (!activeArchives.isEmpty()) {
            context.getLogger().debug("assemble.archive");
        }
        for (ArchiveAssembler archive : activeArchives) {
            if (!archive.isExported()) continue;
            ArchiveAssemblerResolver.resolveArchiveOutputs(context, archive, errors);
        }
    }

    private static void resolveArchiveOutputs(JReleaserContext context, ArchiveAssembler assembler, Errors errors) {
        if (assembler.isAttachPlatform() && !context.isPlatformSelected(PlatformUtils.getCurrentFull())) {
            return;
        }
        Path baseOutputDirectory = context.getAssembleDirectory().resolve(assembler.getName()).resolve(assembler.getType());
        String archiveName = assembler.getResolvedArchiveName(context);
        for (Archive.Format format : assembler.getFormats()) {
            Path path = baseOutputDirectory.resolve(archiveName + "." + format.extension()).toAbsolutePath();
            if (!Files.exists(path, new LinkOption[0])) {
                errors.assembly(RB.$((String)"validation_missing_assembly", (Object[])new Object[]{assembler.getType(), assembler.getName(), assembler.getName()}));
                continue;
            }
            Artifact artifact = Artifact.of(path, assembler.isAttachPlatform() ? PlatformUtils.getCurrentFull() : "");
            artifact.setExtraProperties(assembler.getExtraProperties());
            artifact.activate();
            assembler.addOutput(artifact);
        }
    }
}

