/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.deploy.maven;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jreleaser.model.Http;
import org.jreleaser.model.internal.common.AbstractActivatable;
import org.jreleaser.model.internal.common.ExtraProperties;
import org.jreleaser.model.internal.deploy.maven.MavenDeployer;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.StringUtils;

public abstract class AbstractMavenDeployer<S extends AbstractMavenDeployer<S, A>, A extends org.jreleaser.model.api.deploy.maven.MavenDeployer>
extends AbstractActivatable<S>
implements MavenDeployer<A>,
ExtraProperties {
    private static final long serialVersionUID = -1018438777546427061L;
    @JsonIgnore
    private final String type;
    private final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    private final List<String> stagingRepositories = new ArrayList<String>();
    @JsonIgnore
    private String name;
    private int connectTimeout;
    private int readTimeout;
    protected Boolean sign;
    protected Boolean verifyPom;
    protected Boolean applyMavenCentralRules;
    private String url;
    private String username;
    private String password;
    private Http.Authorization authorization;

    protected AbstractMavenDeployer(String type) {
        this.type = type;
    }

    @Override
    public void merge(S source) {
        super.merge(source);
        this.name = this.merge(this.name, ((AbstractMavenDeployer)source).getName());
        this.connectTimeout = this.merge(this.getConnectTimeout(), ((AbstractMavenDeployer)source).getConnectTimeout());
        this.readTimeout = this.merge(this.getReadTimeout(), ((AbstractMavenDeployer)source).getReadTimeout());
        this.sign = this.merge(this.sign, ((AbstractMavenDeployer)source).sign);
        this.verifyPom = this.merge(this.verifyPom, ((AbstractMavenDeployer)source).verifyPom);
        this.applyMavenCentralRules = this.merge(this.applyMavenCentralRules, ((AbstractMavenDeployer)source).applyMavenCentralRules);
        this.url = this.merge(this.url, ((AbstractMavenDeployer)source).getUrl());
        this.username = this.merge(this.username, ((AbstractMavenDeployer)source).getUsername());
        this.password = this.merge(this.password, ((AbstractMavenDeployer)source).getPassword());
        this.authorization = this.merge(this.authorization, ((AbstractMavenDeployer)source).getAuthorization());
        this.setExtraProperties(this.merge(this.extraProperties, ((AbstractMavenDeployer)source).getExtraProperties()));
        this.setStagingRepositories(this.merge(this.stagingRepositories, ((AbstractMavenDeployer)source).getStagingRepositories()));
    }

    @Override
    public String prefix() {
        return this.getType();
    }

    @Override
    public boolean isSnapshotSupported() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Override
    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.extraProperties;
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public boolean isSign() {
        return null != this.sign && this.sign != false;
    }

    @Override
    public void setSign(Boolean sign) {
        this.sign = sign;
    }

    @Override
    public boolean isSignSet() {
        return null != this.sign;
    }

    @Override
    public boolean isVerifyPom() {
        return null != this.verifyPom && this.verifyPom != false;
    }

    @Override
    public void setVerifyPom(Boolean verifyPom) {
        this.verifyPom = verifyPom;
    }

    @Override
    public boolean isVerifyPomSet() {
        return null != this.verifyPom;
    }

    @Override
    public boolean isApplyMavenCentralRules() {
        return null != this.applyMavenCentralRules && this.applyMavenCentralRules != false;
    }

    @Override
    public void setApplyMavenCentralRules(Boolean applyMavenCentralRules) {
        this.applyMavenCentralRules = applyMavenCentralRules;
    }

    @Override
    public boolean isApplyMavenCentralRulesSet() {
        return null != this.applyMavenCentralRules;
    }

    @Override
    public List<String> getStagingRepositories() {
        return this.stagingRepositories;
    }

    @Override
    public void setStagingRepositories(List<String> stagingRepositories) {
        this.stagingRepositories.clear();
        this.stagingRepositories.addAll(stagingRepositories);
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public Http.Authorization getAuthorization() {
        return this.authorization;
    }

    @Override
    public void setAuthorization(Http.Authorization authorization) {
        this.authorization = authorization;
    }

    @Override
    public void setAuthorization(String authorization) {
        this.authorization = Http.Authorization.of((String)authorization);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("enabled", this.isEnabled());
        props.put("active", this.getActive());
        props.put("connectTimeout", this.connectTimeout);
        props.put("readTimeout", this.readTimeout);
        props.put("authorization", this.authorization);
        props.put("url", this.url);
        props.put("username", StringUtils.isNotBlank((String)this.username) ? "************" : "**unset**");
        props.put("password", StringUtils.isNotBlank((String)this.password) ? "************" : "**unset**");
        props.put("sign", this.isSign());
        props.put("verifyPom", this.isVerifyPom());
        props.put("applyMavenCentralRules", this.isApplyMavenCentralRules());
        props.put("stagingRepositories", this.stagingRepositories);
        this.asMap(full, props);
        props.put("extraProperties", this.getExtraProperties());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(this.getName(), props);
        return map;
    }

    protected abstract void asMap(boolean var1, Map<String, Object> var2);

    @Override
    public String getResolvedUrl(TemplateContext props) {
        props.set("username", (Object)this.username);
        props.set("owner", (Object)this.username);
        props.setAll(this.getExtraProperties());
        return Templates.resolveTemplate((String)this.url, (TemplateContext)props);
    }

    @Override
    public Http.Authorization resolveAuthorization() {
        if (null == this.authorization) {
            this.authorization = Http.Authorization.BASIC;
        }
        return this.authorization;
    }
}

