/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.commons;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.Signing;
import org.jreleaser.model.api.upload.Uploader;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.catalog.sbom.SbomCataloger;
import org.jreleaser.model.internal.checksum.Checksum;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.common.ExtraProperties;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.signing.Signing;
import org.jreleaser.model.internal.upload.ArtifactoryUploader;
import org.jreleaser.model.internal.util.Artifacts;
import org.jreleaser.model.spi.catalog.sbom.SbomCatalogerProcessorHelper;
import org.jreleaser.model.spi.upload.ArtifactUploader;
import org.jreleaser.util.Algorithm;
import org.jreleaser.util.StringUtils;

public abstract class AbstractArtifactUploader<A extends Uploader, U extends org.jreleaser.model.internal.upload.Uploader<A>>
implements ArtifactUploader<A, U> {
    protected final JReleaserContext context;

    protected AbstractArtifactUploader(JReleaserContext context) {
        this.context = context;
    }

    protected Set<Artifact> collectArtifacts() {
        boolean uploadChecksums;
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
        List keys = this.getUploader().resolveSkipKeys();
        Checksum checksum = this.context.getModel().getChecksum();
        boolean bl = uploadChecksums = this.getUploader().isChecksums() && !(this.getUploader() instanceof ArtifactoryUploader);
        if (this.getUploader().isFiles()) {
            for (Artifact artifact : Artifacts.resolveFiles((JReleaserContext)this.context)) {
                if (!artifact.isActive()) continue;
                Path path = artifact.getEffectivePath(this.context);
                if (this.isSkip((ExtraProperties)artifact, keys) || !Files.exists(path, new LinkOption[0]) || 0L == path.toFile().length()) continue;
                artifacts.add(artifact);
                if (!uploadChecksums || !this.isIndividual(this.context, artifact) || artifact.extraPropertyIsTrue("skipChecksum")) continue;
                for (Algorithm algorithm : checksum.getAlgorithms()) {
                    artifacts.add(Artifact.of((Path)this.context.getChecksumsDirectory().resolve(path.getFileName() + "." + algorithm.formatted())));
                }
            }
        }
        if (this.getUploader().isArtifacts()) {
            for (Distribution distribution : this.context.getModel().getActiveDistributions()) {
                if (this.isSkip((ExtraProperties)distribution, keys)) continue;
                for (Artifact artifact : distribution.getArtifacts()) {
                    if (!artifact.isActive()) continue;
                    Path path = artifact.getEffectivePath(this.context, distribution);
                    if (this.isSkip((ExtraProperties)artifact, keys) || !Files.exists(path, new LinkOption[0]) || 0L == path.toFile().length()) continue;
                    String platform = artifact.getPlatform();
                    String platformReplaced = distribution.getPlatform().applyReplacements(platform);
                    if (StringUtils.isNotBlank((String)platformReplaced)) {
                        artifact.getExtraProperties().put("platformReplaced", platformReplaced);
                    }
                    artifacts.add(artifact);
                    if (!uploadChecksums || !this.isIndividual(this.context, distribution, artifact)) continue;
                    for (Algorithm algorithm : checksum.getAlgorithms()) {
                        artifacts.add(Artifact.of((Path)this.context.getChecksumsDirectory().resolve(distribution.getName()).resolve(path.getFileName() + "." + algorithm.formatted())));
                    }
                }
            }
        }
        if (uploadChecksums) {
            for (Object algorithm : checksum.getAlgorithms()) {
                Path checksums = this.context.getChecksumsDirectory().resolve(checksum.getResolvedName(this.context, (Algorithm)algorithm));
                if (!Files.exists(checksums, new LinkOption[0])) continue;
                artifacts.add(Artifact.of((Path)checksums));
            }
        }
        if (this.getUploader().isCatalogs()) {
            List catalogers = this.context.getModel().getCatalog().getSbom().findAllActiveSbomCatalogers();
            for (SbomCataloger cataloger : catalogers) {
                if (!cataloger.getPack().isEnabled()) continue;
                artifacts.addAll(SbomCatalogerProcessorHelper.resolveArtifacts((JReleaserContext)this.context, (SbomCataloger)cataloger));
            }
        }
        Signing signing = this.context.getModel().getSigning();
        if (this.getUploader().isSignatures() && signing.isEnabled()) {
            String extension = signing.getSignatureExtension();
            ArrayList<Artifact> signatures = new ArrayList<Artifact>();
            for (Artifact artifact : artifacts) {
                Path signaturePath;
                if (artifact.extraPropertyIsTrue("skipSigning") || !Files.exists(signaturePath = this.context.getSignaturesDirectory().resolve(artifact.getEffectivePath(this.context).getFileName() + extension), new LinkOption[0]) || 0L == signaturePath.toFile().length()) continue;
                signatures.add(Artifact.of((Path)signaturePath, (Map)artifact.getExtraProperties()));
            }
            if (!signatures.isEmpty() && signing.getMode() == Signing.Mode.COSIGN) {
                Path publicKeyFile = signing.getCosign().getResolvedPublicKeyFilePath(this.context);
                signatures.add(Artifact.of((Path)publicKeyFile));
            }
            artifacts.addAll(signatures);
        }
        if (this.getUploader().isCatalogs()) {
            artifacts.addAll(SbomCatalogerProcessorHelper.resolveArtifacts((JReleaserContext)this.context));
        }
        return artifacts;
    }

    private boolean isSkip(ExtraProperties props, List<String> keys) {
        for (String key : keys) {
            if (!props.extraPropertyIsTrue(key)) continue;
            return true;
        }
        return false;
    }

    private boolean isIndividual(JReleaserContext context, Artifact artifact) {
        if (artifact.getExtraProperties().containsKey("individualChecksum")) {
            return StringUtils.isTrue(artifact.getExtraProperties().get("individualChecksum"));
        }
        return context.getModel().getChecksum().isIndividual();
    }

    private boolean isIndividual(JReleaserContext context, Distribution distribution, Artifact artifact) {
        if (artifact.getExtraProperties().containsKey("individualChecksum")) {
            return StringUtils.isTrue(artifact.getExtraProperties().get("individualChecksum"));
        }
        if (distribution.getExtraProperties().containsKey("individualChecksum")) {
            return StringUtils.isTrue(distribution.getExtraProperties().get("individualChecksum"));
        }
        return context.getModel().getChecksum().isIndividual();
    }
}

