/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.gitea;

import feign.form.FormData;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Set;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.spi.deploy.DeployException;
import org.jreleaser.model.spi.upload.UploadException;
import org.jreleaser.sdk.commons.AbstractMavenDeployer;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.gitea.Gitea;

public class GiteaMavenDeployer
extends AbstractMavenDeployer<org.jreleaser.model.api.deploy.maven.GiteaMavenDeployer, org.jreleaser.model.internal.deploy.maven.GiteaMavenDeployer> {
    private org.jreleaser.model.internal.deploy.maven.GiteaMavenDeployer deployer;

    public GiteaMavenDeployer(JReleaserContext context) {
        super(context);
    }

    public org.jreleaser.model.internal.deploy.maven.GiteaMavenDeployer getDeployer() {
        return this.deployer;
    }

    public void setDeployer(org.jreleaser.model.internal.deploy.maven.GiteaMavenDeployer deployer) {
        this.deployer = deployer;
    }

    public String getType() {
        return "gitea";
    }

    public void deploy(String name) throws DeployException {
        Set deployables = this.collectDeployables();
        if (deployables.isEmpty()) {
            this.context.getLogger().info(RB.$((String)"artifacts.no.match", (Object[])new Object[0]));
        }
        String baseUrl = this.deployer.getResolvedUrl(this.context.fullProps());
        String token = this.deployer.getResolvedPassword();
        for (AbstractMavenDeployer.Deployable deployable : deployables) {
            if (!deployable.getFilename().endsWith(".pom")) continue;
            this.deletePackage(baseUrl, token, deployable);
        }
        for (AbstractMavenDeployer.Deployable deployable : deployables) {
            if (!deployable.getFilename().endsWith(".jar") && !deployable.getFilename().endsWith(".pom")) continue;
            Path localPath = Paths.get(deployable.getStagingRepository(), deployable.getPath(), deployable.getFilename());
            this.context.getLogger().info(" - {}", new Object[]{deployable.getFilename()});
            if (this.context.isDryrun()) continue;
            try {
                LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
                headers.put("Authorization", "token " + token);
                FormData data = ClientUtils.toFormData((Path)localPath);
                String url = baseUrl + deployable.getPath() + "/" + deployable.getFilename();
                ClientUtils.putFile((JReleaserLogger)this.context.getLogger(), (String)url, (int)this.deployer.getConnectTimeout(), (int)this.deployer.getReadTimeout(), (FormData)data, headers);
            }
            catch (IOException | UploadException e) {
                this.context.getLogger().trace(e);
                throw new DeployException(RB.$((String)"ERROR_unexpected_deploy", (Object[])new Object[]{this.context.getBasedir().relativize(localPath)}), e);
            }
        }
    }

    private void deletePackage(String baseUrl, String token, AbstractMavenDeployer.Deployable deployable) throws DeployException {
        URL url = null;
        try {
            url = new URL(baseUrl);
        }
        catch (MalformedURLException e) {
            this.context.getLogger().trace((Throwable)e);
            throw new DeployException(RB.$((String)"ERROR_unexpected_deploy", (Object[])new Object[]{deployable.getGav()}), (Throwable)e);
        }
        StringBuilder theUrl = new StringBuilder(url.getProtocol()).append("://").append(url.getHost());
        if (url.getPort() != -1) {
            theUrl.append(url.getPort());
        }
        try {
            Gitea api = new Gitea(this.context.getLogger(), theUrl.toString(), token, this.deployer.getConnectTimeout(), this.deployer.getReadTimeout());
            api.deletePackage(this.deployer.getUsername(), "maven", deployable.getGroupId() + "-" + deployable.getArtifactId(), deployable.getVersion());
        }
        catch (Exception e) {
            this.context.getLogger().debug(RB.$((String)"ERROR_gitea_delete_package", (Object[])new Object[]{this.deployer.getUsername(), "maven", deployable.getGroupId() + "-" + deployable.getArtifactId(), deployable.getVersion()}));
        }
    }
}

