/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.upload;

import java.util.Collection;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.upload.GitlabUploader;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Env;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class GitlabUploaderValidator
extends Validator {
    public static void validateGitlabUploader(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, GitlabUploader> gitlab = context.getModel().getUpload().getGitlab();
        if (!gitlab.isEmpty()) {
            context.getLogger().debug("upload.gitlab");
        }
        for (Map.Entry<String, GitlabUploader> e : gitlab.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig()) continue;
            GitlabUploaderValidator.validateGitlabUploader(context, mode, e.getValue(), errors);
        }
    }

    private static void validateGitlabUploader(JReleaserContext context, JReleaserContext.Mode mode, GitlabUploader gitlab, Errors errors) {
        context.getLogger().debug("upload.gitlab.{}", new Object[]{gitlab.getName()});
        if (!gitlab.isActiveSet()) {
            gitlab.setActive(Active.NEVER);
        }
        if (!gitlab.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (!(gitlab.isArtifacts() || gitlab.isFiles() || gitlab.isSignatures())) {
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            gitlab.disable();
            return;
        }
        gitlab.setToken(GitlabUploaderValidator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"GITLAB_" + Env.toVar((String)gitlab.getName()) + "_TOKEN", "GITLAB_TOKEN"}), "gitlab.token", gitlab.getToken(), errors, context.isDryrun()));
        gitlab.setHost(GitlabUploaderValidator.checkProperty(context, "GITLAB_" + Env.toVar((String)gitlab.getName()) + "_HOST", "gitlab.host", gitlab.getHost(), errors, context.isDryrun()));
        if (StringUtils.isBlank((String)gitlab.getPackageName())) {
            gitlab.setPackageName(gitlab.getName());
        }
        if (StringUtils.isBlank((String)gitlab.getPackageVersion())) {
            gitlab.setPackageVersion("{{projectVersion}}");
        }
        if (StringUtils.isBlank((String)gitlab.getProjectIdentifier())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"gitlab." + gitlab.getName() + ".projectIdentifier"}));
        }
        GitlabUploaderValidator.validateTimeout(gitlab);
    }
}

