/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.api;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.api.JReleaserCommand;
import org.jreleaser.model.api.JReleaserModel;
import org.jreleaser.model.api.signing.Keyring;
import org.jreleaser.model.api.signing.SigningException;

public interface JReleaserContext {
    public Path relativize(Path var1, Path var2);

    public Path relativizeToBasedir(Path var1);

    public JReleaserLogger getLogger();

    public Mode getMode();

    public JReleaserModel getModel();

    public Path getBasedir();

    public Path getOutputDirectory();

    public Path getChecksumsDirectory();

    public Path getSignaturesDirectory();

    public Path getPrepareDirectory();

    public Path getPackageDirectory();

    public Path getAssembleDirectory();

    public Path getDownloadDirectory();

    public Path getArtifactsDirectory();

    public boolean isDryrun();

    public boolean isGitRootSearch();

    public List<String> getIncludedAnnouncers();

    public List<String> getIncludedAssemblers();

    public List<String> getIncludedDistributions();

    public List<String> getIncludedPackagers();

    public List<String> getIncludedDownloaderTypes();

    public List<String> getIncludedDownloaderNames();

    public List<String> getIncludedDeployerTypes();

    public List<String> getIncludedDeployerNames();

    public List<String> getIncludedUploaderTypes();

    public List<String> getIncludedUploaderNames();

    public List<String> getExcludedAnnouncers();

    public List<String> getExcludedAssemblers();

    public List<String> getExcludedDistributions();

    public List<String> getExcludedPackagers();

    public List<String> getExcludedDownloaderTypes();

    public List<String> getExcludedDownloaderNames();

    public List<String> getExcludedDeployerTypes();

    public List<String> getExcludedDeployerNames();

    public List<String> getExcludedUploaderTypes();

    public List<String> getExcludedUploaderNames();

    public JReleaserCommand getCommand();

    public Map<String, Object> props();

    public Map<String, Object> fullProps();

    public void nag(String var1, String var2);

    public Keyring createKeyring() throws SigningException;

    public static enum Mode {
        CONFIG,
        DOWNLOAD,
        ASSEMBLE,
        FULL,
        CHANGELOG,
        ANNOUNCE;


        public boolean validateChangelog() {
            return this == CHANGELOG;
        }

        public boolean validateAnnounce() {
            return this == ANNOUNCE;
        }

        public boolean validateDownload() {
            return this == DOWNLOAD;
        }

        public boolean validateAssembly() {
            return this == ASSEMBLE;
        }

        public boolean validateStandalone() {
            return this.validateAssembly() || this.validateDownload();
        }

        public boolean validateConfig() {
            return this == CONFIG || this == FULL;
        }

        public boolean validatePaths() {
            return this == FULL;
        }
    }
}

