/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.deploy.maven;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.engine.deploy.maven.ProjectMavenDeployer;
import org.jreleaser.extensions.api.workflow.WorkflowListenerException;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.api.JReleaserCommand;
import org.jreleaser.model.api.hooks.ExecutionEvent;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.JReleaserSupport;
import org.jreleaser.model.internal.deploy.maven.Maven;
import org.jreleaser.model.internal.deploy.maven.MavenDeployer;
import org.jreleaser.model.spi.deploy.DeployException;

public class MavenDeployers {
    public static void deploy(JReleaserContext context) {
        Maven maven = context.getModel().getDeploy().getMaven();
        if (!maven.isEnabled()) {
            context.getLogger().info(RB.$((String)"deployers.not.enabled", (Object[])new Object[0]));
            return;
        }
        if (!context.getIncludedDeployerTypes().isEmpty()) {
            for (String deployerType : context.getIncludedDeployerTypes()) {
                if (!JReleaserSupport.supportedMavenDeployers().contains(deployerType)) {
                    context.getLogger().warn(RB.$((String)"ERROR_unsupported_deployer", (Object[])new Object[]{deployerType}));
                    continue;
                }
                Map deployers = maven.findMavenDeployersByType(deployerType);
                if (deployers.isEmpty()) {
                    context.getLogger().debug(RB.$((String)"deployers.no.match", (Object[])new Object[0]), new Object[]{deployerType});
                    return;
                }
                if (!context.getIncludedDeployerNames().isEmpty()) {
                    for (String deployerName : context.getIncludedDeployerNames()) {
                        if (!deployers.containsKey(deployerName)) {
                            context.getLogger().warn(RB.$((String)"deployers.deployer.not.configured", (Object[])new Object[0]), new Object[]{deployerType, deployerName});
                            continue;
                        }
                        MavenDeployer deployer2 = (MavenDeployer)deployers.get(deployerName);
                        if (!deployer2.isEnabled()) {
                            context.getLogger().info(RB.$((String)"deployers.deployer.disabled", (Object[])new Object[0]), new Object[]{deployerType, deployerName});
                            continue;
                        }
                        context.getLogger().info(RB.$((String)"deployers.deploy.with", (Object[])new Object[0]), new Object[]{deployerType, deployerName});
                        MavenDeployers.deploy(context, deployer2);
                    }
                    continue;
                }
                context.getLogger().info(RB.$((String)"deployers.deploy.all.artifacts.with", (Object[])new Object[0]), new Object[]{deployerType});
                deployers.values().forEach(deployer -> MavenDeployers.deploy(context, deployer));
            }
        } else if (!context.getIncludedDeployerNames().isEmpty()) {
            for (String deployerName : context.getIncludedDeployerNames()) {
                List<MavenDeployer> filteredDeployers = maven.findAllActiveMavenDeployers().stream().filter(a -> deployerName.equals(a.getName())).collect(Collectors.toList());
                if (!filteredDeployers.isEmpty()) {
                    context.getLogger().info(RB.$((String)"deployers.deploy.all.artifacts.to", (Object[])new Object[0]), new Object[]{deployerName});
                    filteredDeployers.forEach(deployer -> MavenDeployers.deploy(context, deployer));
                    continue;
                }
                context.getLogger().warn(RB.$((String)"deployers.deployer.not.configured2", (Object[])new Object[0]), new Object[]{deployerName});
            }
        } else {
            context.getLogger().info(RB.$((String)"deployers.deploy.all.artifacts", (Object[])new Object[0]));
            for (MavenDeployer deployer3 : maven.findAllActiveMavenDeployers()) {
                String deployerType = deployer3.getType();
                String deployerName = deployer3.getName();
                if (context.getExcludedDeployerTypes().contains(deployerType) || context.getExcludedDeployerNames().contains(deployerName)) {
                    context.getLogger().info(RB.$((String)"deployers.deployer.excluded", (Object[])new Object[0]), new Object[]{deployerType, deployerName});
                    continue;
                }
                MavenDeployers.deploy(context, deployer3);
            }
        }
    }

    private static void deploy(JReleaserContext context, MavenDeployer<?> deployer) {
        try {
            context.getLogger().increaseIndent();
            context.getLogger().setPrefix(deployer.getType());
            MavenDeployers.fireDeployEvent(ExecutionEvent.before((String)JReleaserCommand.DEPLOY.toStep()), context, deployer);
            ProjectMavenDeployer projectDeployer = MavenDeployers.createProjectDeployer(context, deployer);
            projectDeployer.deploy();
            MavenDeployers.fireDeployEvent(ExecutionEvent.success((String)JReleaserCommand.DEPLOY.toStep()), context, deployer);
        }
        catch (DeployException e) {
            MavenDeployers.fireDeployEvent(ExecutionEvent.failure((String)JReleaserCommand.DEPLOY.toStep(), (Throwable)e), context, deployer);
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
        finally {
            context.getLogger().restorePrefix();
            context.getLogger().decreaseIndent();
        }
    }

    private static ProjectMavenDeployer createProjectDeployer(JReleaserContext context, MavenDeployer<?> deployer) {
        return ProjectMavenDeployer.builder().context(context).deployer(deployer).build();
    }

    private static void fireDeployEvent(ExecutionEvent event, JReleaserContext context, MavenDeployer<?> deployer) {
        block4: {
            if (!deployer.isEnabled()) {
                return;
            }
            try {
                context.fireDeployStepEvent(event, deployer.asImmutable());
            }
            catch (WorkflowListenerException e) {
                context.getLogger().error(RB.$((String)"listener.failure", (Object[])new Object[]{e.getListener().getClass().getName()}));
                context.getLogger().trace((Throwable)e);
                if (event.getType() == ExecutionEvent.Type.FAILURE || e.getListener().isContinueOnError()) break block4;
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new JReleaserException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), e.getCause());
            }
        }
    }
}

