/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JsonInclude;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.kohsuke.github.GHCheckRun;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.Preview;
import org.kohsuke.github.Requester;
import org.kohsuke.github.internal.Previews;

@Preview(value={Previews.ANTIOPE})
@Deprecated
@SuppressFBWarnings(value={"URF_UNREAD_FIELD"}, justification="Jackson serializes these even without a getter")
public final class GHCheckRunBuilder {
    protected final GHRepository repo;
    protected final Requester requester;
    private Output output;
    private List<Action> actions;
    private static final int MAX_ANNOTATIONS = 50;

    private GHCheckRunBuilder(GHRepository repo, Requester requester) {
        this.repo = repo;
        this.requester = requester;
    }

    GHCheckRunBuilder(GHRepository repo, String name, String headSHA) {
        this(repo, (Requester)((Requester)((Requester)((Requester)((Requester)repo.root.createRequest().withPreview(Previews.ANTIOPE)).method("POST")).with("name", name)).with("head_sha", headSHA)).withUrlPath(repo.getApiTailUrl("check-runs"), new String[0]));
    }

    GHCheckRunBuilder(GHRepository repo, long checkId) {
        this(repo, (Requester)((Requester)((Requester)repo.root.createRequest().withPreview(Previews.ANTIOPE)).method("PATCH")).withUrlPath(repo.getApiTailUrl("check-runs/" + checkId), new String[0]));
    }

    @NonNull
    public GHCheckRunBuilder withDetailsURL(@CheckForNull String detailsURL) {
        this.requester.with("details_url", detailsURL);
        return this;
    }

    @NonNull
    public GHCheckRunBuilder withExternalID(@CheckForNull String externalID) {
        this.requester.with("external_id", externalID);
        return this;
    }

    @NonNull
    public GHCheckRunBuilder withStatus(@CheckForNull GHCheckRun.Status status) {
        if (status != null) {
            this.requester.with("status", status.toString().toLowerCase(Locale.ROOT));
        }
        return this;
    }

    @NonNull
    public GHCheckRunBuilder withConclusion(@CheckForNull GHCheckRun.Conclusion conclusion) {
        if (conclusion != null) {
            this.requester.with("conclusion", conclusion.toString().toLowerCase(Locale.ROOT));
        }
        return this;
    }

    @NonNull
    public GHCheckRunBuilder withStartedAt(@CheckForNull Date startedAt) {
        if (startedAt != null) {
            this.requester.with("started_at", GitHubClient.printDate(startedAt));
        }
        return this;
    }

    @NonNull
    public GHCheckRunBuilder withCompletedAt(@CheckForNull Date completedAt) {
        if (completedAt != null) {
            this.requester.with("completed_at", GitHubClient.printDate(completedAt));
        }
        return this;
    }

    @NonNull
    public GHCheckRunBuilder add(@NonNull Output output) {
        if (this.output != null) {
            throw new IllegalStateException("cannot add Output twice");
        }
        this.output = output;
        return this;
    }

    @NonNull
    public GHCheckRunBuilder add(@NonNull Action action) {
        if (this.actions == null) {
            this.actions = new LinkedList<Action>();
        }
        this.actions.add(action);
        return this;
    }

    @NonNull
    public GHCheckRun create() throws IOException {
        List<Object> extraAnnotations;
        if (this.output != null && this.output.annotations != null && this.output.annotations.size() > 50) {
            extraAnnotations = this.output.annotations.subList(50, this.output.annotations.size());
            this.output.annotations = this.output.annotations.subList(0, 50);
        } else {
            extraAnnotations = Collections.emptyList();
        }
        GHCheckRun run = ((Requester)((Requester)this.requester.with("output", this.output)).with("actions", this.actions)).fetch(GHCheckRun.class).wrap(this.repo);
        while (!extraAnnotations.isEmpty()) {
            Output output2 = new Output(this.output.title, this.output.summary).withText(this.output.text);
            int i = Math.min(extraAnnotations.size(), 50);
            output2.annotations = extraAnnotations.subList(0, i);
            extraAnnotations = extraAnnotations.subList(i, extraAnnotations.size());
            run = ((Requester)((Requester)((Requester)((Requester)this.repo.root.createRequest().withPreview(Previews.ANTIOPE)).method("PATCH")).with("output", output2)).withUrlPath(this.repo.getApiTailUrl("check-runs/" + run.getId()), new String[0])).fetch(GHCheckRun.class).wrap(this.repo);
        }
        return run;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static final class Action {
        private final String label;
        private final String description;
        private final String identifier;

        public Action(@NonNull String label, @NonNull String description, @NonNull String identifier) {
            this.label = label;
            this.description = description;
            this.identifier = identifier;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static final class Image {
        private final String alt;
        private final String image_url;
        private String caption;

        public Image(@NonNull String alt, @NonNull String imageURL) {
            this.alt = alt;
            this.image_url = imageURL;
        }

        @NonNull
        public Image withCaption(@CheckForNull String caption) {
            this.caption = caption;
            return this;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static final class Annotation {
        private final String path;
        private final int start_line;
        private final int end_line;
        private final String annotation_level;
        private final String message;
        private Integer start_column;
        private Integer end_column;
        private String title;
        private String raw_details;

        public Annotation(@NonNull String path, int line, @NonNull GHCheckRun.AnnotationLevel annotationLevel, @NonNull String message) {
            this(path, line, line, annotationLevel, message);
        }

        public Annotation(@NonNull String path, int startLine, int endLine, @NonNull GHCheckRun.AnnotationLevel annotationLevel, @NonNull String message) {
            this.path = path;
            this.start_line = startLine;
            this.end_line = endLine;
            this.annotation_level = annotationLevel.toString().toLowerCase(Locale.ROOT);
            this.message = message;
        }

        @NonNull
        public Annotation withStartColumn(@CheckForNull Integer startColumn) {
            this.start_column = startColumn;
            return this;
        }

        @NonNull
        public Annotation withEndColumn(@CheckForNull Integer endColumn) {
            this.end_column = endColumn;
            return this;
        }

        @NonNull
        public Annotation withTitle(@CheckForNull String title) {
            this.title = title;
            return this;
        }

        @NonNull
        public Annotation withRawDetails(@CheckForNull String rawDetails) {
            this.raw_details = rawDetails;
            return this;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static final class Output {
        private final String title;
        private final String summary;
        private String text;
        private List<Annotation> annotations;
        private List<Image> images;

        public Output(@NonNull String title, @NonNull String summary) {
            this.title = title;
            this.summary = summary;
        }

        @NonNull
        public Output withText(@CheckForNull String text) {
            this.text = text;
            return this;
        }

        @NonNull
        public Output add(@NonNull Annotation annotation) {
            if (this.annotations == null) {
                this.annotations = new LinkedList<Annotation>();
            }
            this.annotations.add(annotation);
            return this;
        }

        @NonNull
        public Output add(@NonNull Image image) {
            if (this.images == null) {
                this.images = new LinkedList<Image>();
            }
            this.images.add(image);
            return this;
        }
    }
}

