/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.common;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.Active;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.AbstractActivatable;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.common.ExtraProperties;

public abstract class AbstractArtifact<S extends AbstractArtifact<S>>
extends AbstractActivatable<S>
implements Domain,
ExtraProperties {
    protected static final String GLOB_PREFIX = "glob:";
    protected static final String REGEX_PREFIX = "regex:";
    private static final long serialVersionUID = 8523164047987463127L;
    private final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    private String platform;
    @JsonIgnore
    private boolean selected;

    protected AbstractArtifact() {
        this.setActive(Active.ALWAYS);
    }

    @Override
    public void merge(S source) {
        super.merge(source);
        this.platform = this.merge(this.platform, ((AbstractArtifact)source).getPlatform());
        this.selected = ((AbstractArtifact)source).isSelected();
        this.setExtraProperties(this.merge(this.extraProperties, ((AbstractArtifact)source).getExtraProperties()));
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean resolveActiveAndSelected(JReleaserContext context) {
        this.resolveEnabled(context.getModel().getProject());
        this.selected = context.isPlatformSelected(this.platform);
        return this.isActiveAndSelected();
    }

    public boolean isActiveAndSelected() {
        return this.isEnabled() && this.selected;
    }

    public void deactivateAndUnselect() {
        this.disable();
        this.selected = false;
    }

    public void select() {
        this.selected = true;
    }

    @Override
    public String prefix() {
        return "artifact";
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.extraProperties;
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.putAll(extraProperties);
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }
}

