/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.assemble;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Archive;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.JavaArchiveAssembler;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.util.Errors;

public final class JavaArchiveAssemblerResolver {
    private JavaArchiveAssemblerResolver() {
    }

    public static void resolveJavaArchiveOutputs(JReleaserContext context, Errors errors) {
        List<JavaArchiveAssembler> activeArchives = context.getModel().getAssemble().getActiveJavaArchives();
        if (!activeArchives.isEmpty()) {
            context.getLogger().debug("assemble.java-archive");
        }
        for (JavaArchiveAssembler archive : activeArchives) {
            if (!archive.isExported()) continue;
            JavaArchiveAssemblerResolver.resolveJavaArchiveOutputs(context, archive, errors);
        }
    }

    public static void resolveJavaArchiveOutputs(JReleaserContext context, JavaArchiveAssembler assembler, Errors errors) {
        Path baseOutputDirectory = context.getAssembleDirectory().resolve(assembler.getName()).resolve(assembler.getType());
        String archiveName = assembler.getResolvedArchiveName(context);
        for (Archive.Format format : assembler.getFormats()) {
            Path path = baseOutputDirectory.resolve(archiveName + "." + format.extension()).toAbsolutePath();
            if (!Files.exists(path, new LinkOption[0])) {
                errors.assembly(RB.$((String)"validation_missing_assembly", (Object[])new Object[]{assembler.getType(), assembler.getName(), assembler.getName()}));
                continue;
            }
            Artifact artifact = Artifact.of(path);
            artifact.resolveActiveAndSelected(context);
            artifact.setExtraProperties(assembler.getExtraProperties());
            assembler.addOutput(artifact);
        }
    }
}

