/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.gitlab.internal;

import java.util.Collection;
import java.util.Map;
import org.jreleaser.sdk.commons.Links;

public class Page<T> {
    private final int nextPage;
    private final int page;
    private final int perPage;
    private final int prevPage;
    private final int total;
    private final int totalPages;
    private final Links links;
    private final T content;

    public Page(Map<String, Collection<String>> headers, T content) {
        this.nextPage = this.resolveInt(headers, "x-next-page");
        this.page = this.resolveInt(headers, "x-page");
        this.perPage = this.resolveInt(headers, "x-per-page");
        this.prevPage = this.resolveInt(headers, "x-prev-page");
        this.total = this.resolveInt(headers, "x-total");
        this.totalPages = this.resolveInt(headers, "x-total-pages");
        this.links = Links.of(headers.get("link"));
        this.content = content;
    }

    public boolean hasLinks() {
        return !this.links.isEmpty();
    }

    public int getNextPage() {
        return this.nextPage;
    }

    public int getPage() {
        return this.page;
    }

    public int getPerPage() {
        return this.perPage;
    }

    public int getPrevPage() {
        return this.prevPage;
    }

    public int getTotal() {
        return this.total;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public Links getLinks() {
        return this.links;
    }

    public T getContent() {
        return this.content;
    }

    private int resolveInt(Map<String, Collection<String>> headers, String key) {
        Collection<String> values = headers.get(key);
        if (null != values && !values.isEmpty()) {
            try {
                return Integer.parseInt(values.iterator().next());
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return 0;
    }

    public String toString() {
        return "Page[nextPage=" + this.nextPage + ", page=" + this.page + ", perPage=" + this.perPage + ", prevPage=" + this.prevPage + ", total=" + this.total + ", totalPages=" + this.totalPages + ", links=" + this.links + "]";
    }
}

