/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.announce;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collection;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.BlueskyAnnouncer;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public class BlueskyAnnouncerValidator {
    private BlueskyAnnouncerValidator() {
    }

    public static void validateBluesky(JReleaserContext context, BlueskyAnnouncer announcer, Errors errors) {
        context.getLogger().debug("announce.bluesky");
        Validator.resolveActivatable(context, (Activatable)announcer, "announce.bluesky", "NEVER");
        if (!announcer.resolveEnabledWithSnapshot(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        announcer.setHost(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.bluesky.host", "bluesky.host"}), "announce.bluesky.host", announcer.getHost(), errors));
        announcer.setHandle(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.bluesky.handle", "bluesky.handle"}), "announce.bluesky.handle", announcer.getHandle(), errors));
        announcer.setPassword(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.bluesky.password", "BLUESKY_PASSWORD"}), "announce.bluesky.password", announcer.getPassword(), errors, context.isDryrun()));
        if (StringUtils.isNotBlank((String)announcer.getStatusTemplate()) && !Files.exists(context.getBasedir().resolve(announcer.getStatusTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"bluesky.statusTemplate", announcer.getStatusTemplate()}));
        }
        if (StringUtils.isBlank((String)announcer.getStatus()) && StringUtils.isBlank((String)announcer.getStatusTemplate()) && announcer.getStatuses().isEmpty()) {
            announcer.setStatus(RB.$((String)"default.release.message", (Object[])new Object[0]));
        }
        Validator.validateTimeout(announcer);
    }
}

