/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.mastodon;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.spi.announce.AnnounceException;
import org.jreleaser.model.spi.announce.Announcer;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.sdk.mastodon.MastodonException;
import org.jreleaser.sdk.mastodon.MastodonSdk;
import org.jreleaser.util.StringUtils;

public class MastodonAnnouncer
implements Announcer<org.jreleaser.model.api.announce.MastodonAnnouncer> {
    private final JReleaserContext context;
    private final org.jreleaser.model.internal.announce.MastodonAnnouncer mastodon;

    public MastodonAnnouncer(JReleaserContext context) {
        this.context = context;
        this.mastodon = context.getModel().getAnnounce().getMastodon();
    }

    public org.jreleaser.model.api.announce.MastodonAnnouncer getAnnouncer() {
        return this.mastodon.asImmutable();
    }

    public String getName() {
        return "mastodon";
    }

    public boolean isEnabled() {
        return this.mastodon.isEnabled();
    }

    public void announce() throws AnnounceException {
        ArrayList<String> statuses = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)this.mastodon.getStatusTemplate())) {
            TemplateContext props = new TemplateContext();
            this.context.getModel().getRelease().getReleaser().fillProps(props, this.context.getModel());
            Arrays.stream(this.mastodon.getResolvedStatusTemplate(this.context, props).split(System.lineSeparator())).filter(StringUtils::isNotBlank).map(String::trim).forEach(statuses::add);
        }
        if (statuses.isEmpty() && !this.mastodon.getStatuses().isEmpty()) {
            this.mastodon.getStatuses().stream().filter(StringUtils::isNotBlank).map(String::trim).forEach(statuses::add);
        }
        if (statuses.isEmpty()) {
            statuses.add(this.mastodon.getStatus());
        }
        for (int i = 0; i < statuses.size(); ++i) {
            String status = this.getResolvedMessage(this.context, (String)statuses.get(i));
            this.context.getLogger().info(RB.$((String)"mastodon.toot", (Object[])new Object[0]), new Object[]{status});
            this.context.getLogger().debug(RB.$((String)"mastodon.toot.size", (Object[])new Object[0]), new Object[]{status.length()});
            statuses.set(i, status);
        }
        try {
            MastodonSdk sdk = MastodonSdk.builder(this.context.asImmutable()).host(this.mastodon.getHost()).accessToken(this.mastodon.getAccessToken()).connectTimeout(this.mastodon.getConnectTimeout()).readTimeout(this.mastodon.getReadTimeout()).dryrun(this.context.isDryrun()).build();
            sdk.toot(statuses);
        }
        catch (MastodonException e) {
            throw new AnnounceException((Throwable)e);
        }
    }

    private String getResolvedMessage(JReleaserContext context, String message) {
        TemplateContext props = context.fullProps();
        MustacheUtils.applyTemplates((TemplateContext)props, (Map)context.getModel().getAnnounce().getMastodon().resolvedExtraProperties());
        props.set("tagName", (Object)context.getModel().getRelease().getReleaser().getEffectiveTagName(context.getModel()));
        props.set("previousTagName", (Object)context.getModel().getRelease().getReleaser().getResolvedPreviousTagName(context.getModel()));
        return Templates.resolveTemplate((String)message, (TemplateContext)props);
    }
}

