/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.util.Date;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Requester;

public class GHCommitQueryBuilder {
    private final Requester req;
    private final GHRepository repo;

    GHCommitQueryBuilder(GHRepository repo) {
        this.repo = repo;
        this.req = repo.root.createRequest();
    }

    public GHCommitQueryBuilder author(String author) {
        this.req.with("author", author);
        return this;
    }

    public GHCommitQueryBuilder path(String path) {
        this.req.with("path", path);
        return this;
    }

    public GHCommitQueryBuilder from(String ref) {
        this.req.with("sha", ref);
        return this;
    }

    public GHCommitQueryBuilder pageSize(int pageSize) {
        this.req.with("per_page", pageSize);
        return this;
    }

    public GHCommitQueryBuilder since(Date dt) {
        this.req.with("since", GitHubClient.printDate(dt));
        return this;
    }

    public GHCommitQueryBuilder since(long timestamp) {
        return this.since(new Date(timestamp));
    }

    public GHCommitQueryBuilder until(Date dt) {
        this.req.with("until", GitHubClient.printDate(dt));
        return this;
    }

    public GHCommitQueryBuilder until(long timestamp) {
        return this.until(new Date(timestamp));
    }

    public PagedIterable<GHCommit> list() {
        return ((Requester)this.req.withUrlPath(this.repo.getApiTailUrl("commits"), new String[0])).toIterable(GHCommit[].class, item -> item.wrapUp(this.repo));
    }
}

