/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.function.Predicate;
import org.jreleaser.model.GitService;
import org.jreleaser.model.Project;
import org.jreleaser.util.StringUtils;

public enum Active {
    ALWAYS(project -> true),
    NEVER(project -> false),
    RELEASE(Project::isRelease),
    PRERELEASE(project -> true),
    RELEASE_PRERELEASE(Project::isRelease),
    SNAPSHOT(Project::isSnapshot);

    private final Predicate<Project> test;

    private Active(Predicate<Project> test) {
        this.test = test;
    }

    public boolean check(Project project) {
        return this.test.test(project);
    }

    public boolean check(Project project, GitService service) {
        boolean p = this.test.test(project);
        if (p && (this == PRERELEASE || this == RELEASE_PRERELEASE)) {
            return service.getPrerelease().isEnabled();
        }
        return p;
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    public static Active of(String str) {
        if (StringUtils.isBlank((String)str)) {
            return null;
        }
        return Active.valueOf(str.toUpperCase().trim().replace("+", "_").replace("-", "_").replace(" ", "_"));
    }
}

