/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.gitlab;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.ExtraProperties;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.UpdateSection;
import org.jreleaser.model.Uploader;
import org.jreleaser.model.releaser.spi.AbstractReleaser;
import org.jreleaser.model.releaser.spi.Asset;
import org.jreleaser.model.releaser.spi.ReleaseException;
import org.jreleaser.model.releaser.spi.Repository;
import org.jreleaser.model.releaser.spi.User;
import org.jreleaser.model.util.Artifacts;
import org.jreleaser.sdk.commons.RestAPIException;
import org.jreleaser.sdk.git.GitSdk;
import org.jreleaser.sdk.git.ReleaseUtils;
import org.jreleaser.sdk.gitlab.Gitlab;
import org.jreleaser.sdk.gitlab.api.FileUpload;
import org.jreleaser.sdk.gitlab.api.LinkRequest;
import org.jreleaser.sdk.gitlab.api.Milestone;
import org.jreleaser.sdk.gitlab.api.Project;
import org.jreleaser.sdk.gitlab.api.Release;
import org.jreleaser.util.StringUtils;

public class GitlabReleaser
extends AbstractReleaser {
    public GitlabReleaser(JReleaserContext context, List<Asset> assets) {
        super(context, assets);
    }

    protected void createTag() throws ReleaseException {
        ReleaseUtils.createTag((JReleaserContext)this.context);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createRelease() throws ReleaseException {
        org.jreleaser.model.Gitlab gitlab = this.context.getModel().getRelease().getGitlab();
        this.context.getLogger().info(RB.$((String)"git.releaser.releasing", (Object[])new Object[0]), new Object[]{gitlab.getResolvedRepoUrl(this.context.getModel())});
        String tagName = gitlab.getEffectiveTagName(this.context.getModel());
        try {
            String branch = gitlab.getBranch();
            List branchNames = GitSdk.of((JReleaserContext)this.context).getRemoteBranches();
            if (!branchNames.contains(branch)) {
                throw new ReleaseException(RB.$((String)"ERROR_git_release_branch_not_exists", (Object[])new Object[]{branch, branchNames}));
            }
            String changelog = this.context.getChangelog();
            Gitlab api = new Gitlab(this.context.getLogger(), gitlab.getApiEndpoint(), gitlab.getResolvedToken(), gitlab.getConnectTimeout(), gitlab.getReadTimeout());
            this.context.getLogger().debug(RB.$((String)"git.releaser.release.lookup", (Object[])new Object[0]), new Object[]{tagName, gitlab.getCanonicalRepoName()});
            Release release = api.findReleaseByTag(gitlab.getOwner(), gitlab.getName(), gitlab.getIdentifier(), tagName);
            boolean snapshot = this.context.getModel().getProject().isSnapshot();
            if (null != release) {
                this.context.getLogger().debug(RB.$((String)"git.releaser.release.exists", (Object[])new Object[0]), new Object[]{tagName});
                if (gitlab.isOverwrite() || snapshot) {
                    this.context.getLogger().debug(RB.$((String)"git.releaser.release.delete", (Object[])new Object[0]), new Object[]{tagName});
                    if (!this.context.isDryrun()) {
                        api.deleteRelease(gitlab.getOwner(), gitlab.getName(), gitlab.getIdentifier(), tagName);
                    }
                    this.context.getLogger().debug(RB.$((String)"git.releaser.release.create", (Object[])new Object[0]), new Object[]{tagName});
                    this.createRelease(api, tagName, changelog, gitlab.isMatch());
                    return;
                }
                if (gitlab.getUpdate().isEnabled()) {
                    this.context.getLogger().debug(RB.$((String)"git.releaser.release.update", (Object[])new Object[0]), new Object[]{tagName});
                    if (this.context.isDryrun()) return;
                    boolean update = false;
                    Release updater = new Release();
                    if (gitlab.getUpdate().getSections().contains(UpdateSection.TITLE)) {
                        update = true;
                        this.context.getLogger().info(RB.$((String)"git.releaser.release.update.title", (Object[])new Object[0]), new Object[]{gitlab.getEffectiveReleaseName()});
                        updater.setName(gitlab.getEffectiveReleaseName());
                    }
                    if (gitlab.getUpdate().getSections().contains(UpdateSection.BODY)) {
                        update = true;
                        this.context.getLogger().info(RB.$((String)"git.releaser.release.update.body", (Object[])new Object[0]));
                        updater.setDescription(changelog);
                    }
                    if (update) {
                        api.updateRelease(gitlab.getOwner(), gitlab.getName(), gitlab.getIdentifier(), updater);
                    }
                    if (!gitlab.getUpdate().getSections().contains(UpdateSection.ASSETS)) return;
                    if (!this.assets.isEmpty()) {
                        Collection<FileUpload> uploads = api.uploadAssets(gitlab.getOwner(), gitlab.getName(), gitlab.getIdentifier(), this.assets);
                        api.linkReleaseAssets(gitlab.getOwner(), gitlab.getName(), release, gitlab.getIdentifier(), uploads);
                    }
                    if (gitlab.getUploadLinks().isEmpty()) return;
                    Collection<LinkRequest> links = this.collectUploadLinks(gitlab);
                    api.linkAssets(gitlab.getOwner(), gitlab.getName(), release, gitlab.getIdentifier(), links);
                    return;
                }
                if (this.context.isDryrun()) {
                    this.context.getLogger().debug(RB.$((String)"git.releaser.release.create", (Object[])new Object[0]), new Object[]{tagName});
                    this.createRelease(api, tagName, changelog, false);
                    return;
                }
                throw new IllegalStateException(RB.$((String)"ERROR_git_releaser_cannot_release", (Object[])new Object[]{"GitLab", tagName}));
            }
            this.context.getLogger().debug(RB.$((String)"git.releaser.release.not.found", (Object[])new Object[0]), new Object[]{tagName});
            this.context.getLogger().debug(RB.$((String)"git.releaser.release.create", (Object[])new Object[0]), new Object[]{tagName});
            this.createRelease(api, tagName, changelog, snapshot && gitlab.isMatch());
            return;
        }
        catch (RestAPIException e) {
            this.context.getLogger().trace(e.getStatus() + " " + e.getReason());
            this.context.getLogger().trace((Throwable)e);
            throw new ReleaseException((Throwable)e);
        }
        catch (IOException | IllegalStateException e) {
            this.context.getLogger().trace((Throwable)e);
            throw new ReleaseException((Throwable)e);
        }
    }

    public Repository maybeCreateRepository(String owner, String repo, String password) throws IOException {
        Project project;
        Gitlab api;
        block3: {
            org.jreleaser.model.Gitlab gitlab = this.context.getModel().getRelease().getGitlab();
            this.context.getLogger().debug(RB.$((String)"git.repository.lookup", (Object[])new Object[0]), new Object[]{owner, repo});
            api = new Gitlab(this.context.getLogger(), gitlab.getApiEndpoint(), password, gitlab.getConnectTimeout(), gitlab.getReadTimeout());
            project = null;
            try {
                project = api.findProject(repo, gitlab.getIdentifier());
            }
            catch (RestAPIException e) {
                if (e.isNotFound()) break block3;
                throw e;
            }
        }
        if (null == project) {
            project = api.createProject(owner, repo);
        }
        return new Repository(Repository.Kind.GITLAB, owner, repo, project.getWebUrl(), project.getHttpUrlToRepo());
    }

    public Optional<User> findUser(String email, String name) {
        org.jreleaser.model.Gitlab gitlab = this.context.getModel().getRelease().getGitlab();
        try {
            return new Gitlab(this.context.getLogger(), gitlab.getApiEndpoint(), gitlab.getResolvedToken(), gitlab.getConnectTimeout(), gitlab.getReadTimeout()).findUser(email, name);
        }
        catch (IOException | RestAPIException e) {
            this.context.getLogger().trace(e);
            this.context.getLogger().debug(RB.$((String)"git.releaser.user.not.found", (Object[])new Object[0]), new Object[]{email});
            return Optional.empty();
        }
    }

    private void createRelease(Gitlab api, String tagName, String changelog, boolean deleteTags) throws IOException {
        Optional<Milestone> milestone;
        org.jreleaser.model.Gitlab gitlab = this.context.getModel().getRelease().getGitlab();
        Collection<LinkRequest> links = this.collectUploadLinks(gitlab);
        if (this.context.isDryrun()) {
            if (!this.assets.isEmpty()) {
                for (Asset asset : this.assets) {
                    if (0L == Files.size(asset.getPath()) || !Files.exists(asset.getPath(), new LinkOption[0])) continue;
                    this.context.getLogger().info(" " + RB.$((String)"git.upload.asset", (Object[])new Object[0]), new Object[]{asset.getFilename()});
                }
            }
            if (!links.isEmpty()) {
                for (LinkRequest link : links) {
                    this.context.getLogger().info(" " + RB.$((String)"git.upload.asset", (Object[])new Object[0]), new Object[]{link.getName()});
                }
            }
            return;
        }
        if (deleteTags) {
            this.deleteTags(api, gitlab.getOwner(), gitlab.getName(), gitlab.getIdentifier(), tagName);
        }
        if (deleteTags || !gitlab.isSkipTag()) {
            this.context.getLogger().debug(RB.$((String)"git.releaser.repository.tag", (Object[])new Object[0]), new Object[]{tagName});
            GitSdk.of((JReleaserContext)this.context).tag(tagName, true, this.context);
        }
        Release release = new Release();
        release.setName(gitlab.getEffectiveReleaseName());
        release.setTagName(tagName);
        release.setRef(gitlab.getBranch());
        release.setDescription(changelog);
        api.createRelease(gitlab.getOwner(), gitlab.getName(), gitlab.getIdentifier(), release);
        if (!this.assets.isEmpty()) {
            Collection<FileUpload> uploads = api.uploadAssets(gitlab.getOwner(), gitlab.getName(), gitlab.getIdentifier(), this.assets);
            api.linkReleaseAssets(gitlab.getOwner(), gitlab.getName(), release, gitlab.getIdentifier(), uploads);
        }
        if (!links.isEmpty()) {
            api.linkAssets(gitlab.getOwner(), gitlab.getName(), release, gitlab.getIdentifier(), links);
        }
        if (gitlab.getMilestone().isClose().booleanValue() && !this.context.getModel().getProject().isSnapshot() && (milestone = api.findMilestoneByName(gitlab.getOwner(), gitlab.getName(), gitlab.getIdentifier(), gitlab.getMilestone().getEffectiveName())).isPresent()) {
            api.closeMilestone(gitlab.getOwner(), gitlab.getName(), gitlab.getIdentifier(), milestone.get());
        }
    }

    private Collection<LinkRequest> collectUploadLinks(org.jreleaser.model.Gitlab gitlab) {
        ArrayList<LinkRequest> links = new ArrayList<LinkRequest>();
        for (Map.Entry e : gitlab.getUploadLinks().entrySet()) {
            Optional uploader = this.context.getModel().getUpload().getActiveUploader((String)e.getKey(), (String)e.getValue());
            if (!uploader.isPresent()) continue;
            this.collectUploadLinks((Uploader)uploader.get(), links);
        }
        return links;
    }

    private void collectUploadLinks(Uploader uploader, List<LinkRequest> links) {
        List keys = uploader.resolveSkipKeys();
        keys.add("skipGitlabLinks");
        ArrayList<Object> artifacts = new ArrayList<Object>();
        if (uploader.isFiles().booleanValue()) {
            for (Artifact artifact : Artifacts.resolveFiles((JReleaserContext)this.context)) {
                if (!artifact.isActive()) continue;
                Path path = artifact.getEffectivePath(this.context);
                if (this.isSkip((ExtraProperties)artifact, keys) || !Files.exists(path, new LinkOption[0]) || 0L == path.toFile().length()) continue;
                artifacts.add(artifact);
            }
        }
        if (uploader.isArtifacts().booleanValue()) {
            for (Distribution distribution : this.context.getModel().getActiveDistributions()) {
                if (this.isSkip((ExtraProperties)distribution, keys)) continue;
                for (Artifact artifact : distribution.getArtifacts()) {
                    if (!artifact.isActive()) continue;
                    Path path = artifact.getEffectivePath(this.context, distribution);
                    if (this.isSkip((ExtraProperties)artifact, keys) || !Files.exists(path, new LinkOption[0]) || 0L == path.toFile().length()) continue;
                    String platform = artifact.getPlatform();
                    String platformReplaced = distribution.getPlatform().applyReplacements(platform);
                    if (StringUtils.isNotBlank((String)platformReplaced)) {
                        artifact.getExtraProperties().put("platformReplaced", platformReplaced);
                    }
                    artifacts.add(artifact);
                }
            }
        }
        if (uploader.isSignatures().booleanValue() && this.context.getModel().getSigning().isEnabled()) {
            String extension = this.context.getModel().getSigning().isArmored() != false ? ".asc" : ".sig";
            ArrayList<Artifact> arrayList = new ArrayList<Artifact>();
            for (Artifact artifact : artifacts) {
                Path signaturePath;
                if (artifact.extraPropertyIsTrue("skipSigning") || !Files.exists(signaturePath = this.context.getSignaturesDirectory().resolve(artifact.getEffectivePath(this.context).getFileName() + extension), new LinkOption[0]) || 0L == signaturePath.toFile().length()) continue;
                arrayList.add(Artifact.of((Path)signaturePath));
            }
            artifacts.addAll(arrayList);
        }
        for (Artifact artifact : artifacts) {
            links.add(GitlabReleaser.toLinkRequest(artifact.getEffectivePath(), uploader.getResolvedDownloadUrl(this.context, artifact)));
        }
    }

    private boolean isSkip(ExtraProperties props, List<String> keys) {
        for (String key : keys) {
            if (!props.extraPropertyIsTrue(key)) continue;
            return true;
        }
        return false;
    }

    private void deleteTags(Gitlab api, String owner, String repo, String identifier, String tagName) {
        try {
            api.deleteTag(owner, repo, identifier, tagName);
        }
        catch (RestAPIException restAPIException) {
            // empty catch block
        }
    }

    private static LinkRequest toLinkRequest(Path path, String url) {
        LinkRequest link = new LinkRequest();
        link.setName(path.getFileName().toString());
        link.setUrl(url);
        link.setFilepath("/" + link.getName());
        return link;
    }
}

