/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.mastodon;

import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Mastodon;
import org.jreleaser.model.announcer.spi.AnnounceException;
import org.jreleaser.model.announcer.spi.Announcer;
import org.jreleaser.sdk.mastodon.MastodonException;
import org.jreleaser.sdk.mastodon.MastodonSdk;

public class MastodonAnnouncer
implements Announcer {
    private final JReleaserContext context;

    MastodonAnnouncer(JReleaserContext context) {
        this.context = context;
    }

    public String getName() {
        return "mastodon";
    }

    public boolean isEnabled() {
        return this.context.getModel().getAnnounce().getMastodon().isEnabled();
    }

    public void announce() throws AnnounceException {
        Mastodon mastodon = this.context.getModel().getAnnounce().getMastodon();
        String status = mastodon.getResolvedStatus(this.context);
        this.context.getLogger().debug("status: {}", new Object[]{status});
        try {
            MastodonSdk sdk = MastodonSdk.builder(this.context.getLogger()).host(mastodon.getHost()).accessToken(mastodon.getResolvedAccessToken()).connectTimeout(mastodon.getConnectTimeout()).readTimeout(mastodon.getReadTimeout()).dryrun(this.context.isDryrun()).build();
            sdk.status(status);
        }
        catch (MastodonException e) {
            throw new AnnounceException((Throwable)e);
        }
    }
}

