/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.sdkman;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.sdk.sdkman.AbstractSdkmanCommand;
import org.jreleaser.sdk.sdkman.SdkmanException;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.StringUtils;

public class ReleaseSdkmanCommand
extends AbstractSdkmanCommand {
    private final Map<String, String> platforms = new LinkedHashMap<String, String>();

    private ReleaseSdkmanCommand(JReleaserLogger logger, String apiHost, int connectTimeout, int readTimeout, String consumerKey, String consumerToken, String candidate, String version, boolean dryrun, Map<String, String> platforms) {
        super(logger, apiHost, connectTimeout, readTimeout, consumerKey, consumerToken, candidate, version, dryrun);
        this.platforms.putAll(platforms);
    }

    @Override
    public void execute() throws SdkmanException {
        this.sdkman.release(this.candidate, this.version, this.platforms);
    }

    public static Builder builder(JReleaserLogger logger) {
        return new Builder(logger);
    }

    public static class Builder
    extends AbstractSdkmanCommand.Builder<Builder> {
        private final Map<String, String> platforms = new LinkedHashMap<String, String>();
        private String url;

        protected Builder(JReleaserLogger logger) {
            super(logger);
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder platforms(Map<String, String> platforms) {
            this.platforms.putAll(platforms);
            return this;
        }

        public Builder platform(String platform, String url) {
            this.platforms.put(StringUtils.requireNonBlank((String)platform, (String)"'platform' must not be blank").trim(), StringUtils.requireNonBlank((String)url, (String)"'url' must not be blank").trim());
            return this;
        }

        public ReleaseSdkmanCommand build() {
            StringUtils.requireNonBlank((String)this.apiHost, (String)"'apiHost' must not be blank");
            StringUtils.requireNonBlank((String)this.consumerKey, (String)"'consumerKey' must not be blank");
            StringUtils.requireNonBlank((String)this.consumerToken, (String)"'consumerToken' must not be blank");
            StringUtils.requireNonBlank((String)this.candidate, (String)"'candidate' must not be blank");
            StringUtils.requireNonBlank((String)this.version, (String)"'version' must not be blank");
            if (this.platforms.isEmpty() && StringUtils.isBlank((String)this.url)) {
                throw new IllegalArgumentException("Missing url");
            }
            if (StringUtils.isNotBlank((String)this.url)) {
                this.platforms.put("UNIVERSAL", this.url);
            }
            return new ReleaseSdkmanCommand(this.logger, this.apiHost, this.connectTimeout, this.readTimeout, this.consumerKey, this.consumerToken, this.candidate, this.version, this.dryrun, this.platforms);
        }
    }
}

