/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Archive;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.PlatformUtils;

public abstract class ArchiveResolver
extends Validator {
    public static void resolveArchiveOutputs(JReleaserContext context, Errors errors) {
        context.getLogger().debug("archive");
        for (Archive archive : context.getModel().getAssemble().getActiveArchives()) {
            if (!archive.isExported()) continue;
            ArchiveResolver.resolveArchiveOutputs(context, archive, errors);
        }
    }

    private static void resolveArchiveOutputs(JReleaserContext context, Archive archive, Errors errors) {
        if (archive.isAttachPlatform() && !context.isPlatformSelected(PlatformUtils.getCurrentFull())) {
            return;
        }
        Path baseOutputDirectory = context.getAssembleDirectory().resolve(archive.getName()).resolve(archive.getType());
        String archiveName = archive.getResolvedArchiveName(context);
        for (Archive.Format format : archive.getFormats()) {
            Path path = baseOutputDirectory.resolve(archiveName + "." + format.extension()).toAbsolutePath();
            if (!Files.exists(path, new LinkOption[0])) {
                errors.assembly(RB.$((String)"validation_missing_assembly", (Object[])new Object[]{archive.getType(), archive.getName(), archive.getName()}));
                continue;
            }
            Artifact artifact = Artifact.of(path, archive.isAttachPlatform() ? PlatformUtils.getCurrentFull() : "");
            artifact.setExtraProperties(archive.getExtraProperties());
            artifact.activate();
            archive.addOutput(artifact);
        }
    }
}

