/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.AbstractJavaAssembler;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Domain;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Templates;

public class Jlink
extends AbstractJavaAssembler {
    public static final String TYPE = "jlink";
    private final Set<Artifact> targetJdks = new LinkedHashSet<Artifact>();
    private final Set<String> moduleNames = new LinkedHashSet<String>();
    private final Set<String> additionalModuleNames = new LinkedHashSet<String>();
    private final List<String> args = new ArrayList<String>();
    private final Artifact jdk = new Artifact();
    private final Jdeps jdeps = new Jdeps();
    private String imageName;
    private String imageNameTransform;
    private Boolean copyJars;

    public Jlink() {
        super(TYPE);
    }

    @Override
    public Distribution.DistributionType getDistributionType() {
        return Distribution.DistributionType.JLINK;
    }

    void setAll(Jlink jlink) {
        super.setAll(jlink);
        this.imageName = jlink.imageName;
        this.imageNameTransform = jlink.imageNameTransform;
        this.copyJars = jlink.copyJars;
        this.setJdeps(jlink.jdeps);
        this.setJdk(jlink.jdk);
        this.setTargetJdks(jlink.targetJdks);
        this.setModuleNames(jlink.moduleNames);
        this.setAdditionalModuleNames(jlink.additionalModuleNames);
        this.setArgs(jlink.args);
    }

    public String getResolvedImageName(JReleaserContext context) {
        Map<String, Object> props = context.getModel().props();
        props.putAll(this.props());
        return Templates.resolveTemplate((String)this.imageName, props);
    }

    public String getResolvedImageNameTransform(JReleaserContext context) {
        if (StringUtils.isBlank((String)this.imageNameTransform)) {
            return null;
        }
        Map<String, Object> props = context.getModel().props();
        props.putAll(this.props());
        return Templates.resolveTemplate((String)this.imageNameTransform, props);
    }

    public Jdeps getJdeps() {
        return this.jdeps;
    }

    public void setJdeps(Jdeps jdeps) {
        this.jdeps.setAll(jdeps);
    }

    public Artifact getJdk() {
        return this.jdk;
    }

    public void setJdk(Artifact jdk) {
        this.jdk.setAll(jdk);
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public String getImageNameTransform() {
        return this.imageNameTransform;
    }

    public void setImageNameTransform(String imageNameTransform) {
        this.imageNameTransform = imageNameTransform;
    }

    public Set<Artifact> getTargetJdks() {
        return Artifact.sortArtifacts(this.targetJdks);
    }

    public void setTargetJdks(Set<Artifact> targetJdks) {
        this.targetJdks.clear();
        this.targetJdks.addAll(targetJdks);
    }

    public void addTargetJdks(Set<Artifact> targetJdks) {
        this.targetJdks.addAll(targetJdks);
    }

    public void addTargetJdk(Artifact jdk) {
        if (null != jdk) {
            this.targetJdks.add(jdk);
        }
    }

    public Set<String> getModuleNames() {
        return this.moduleNames;
    }

    public void setModuleNames(Set<String> moduleNames) {
        this.moduleNames.clear();
        this.moduleNames.addAll(moduleNames);
    }

    public void addModuleNames(List<String> moduleNames) {
        this.moduleNames.addAll(moduleNames);
    }

    public void addModuleName(String moduleName) {
        if (StringUtils.isNotBlank((String)moduleName)) {
            this.moduleNames.add(moduleName.trim());
        }
    }

    public void removeModuleName(String moduleName) {
        if (StringUtils.isNotBlank((String)moduleName)) {
            this.moduleNames.remove(moduleName.trim());
        }
    }

    public Set<String> getAdditionalModuleNames() {
        return this.additionalModuleNames;
    }

    public void setAdditionalModuleNames(Set<String> additionalModuleNames) {
        this.additionalModuleNames.clear();
        this.additionalModuleNames.addAll(additionalModuleNames);
    }

    public void addAdditionalModuleNames(List<String> additionalModuleNames) {
        this.additionalModuleNames.addAll(additionalModuleNames);
    }

    public void addAdditionalModuleName(String additionalModuleName) {
        if (StringUtils.isNotBlank((String)additionalModuleName)) {
            this.additionalModuleNames.add(additionalModuleName.trim());
        }
    }

    public void removeAdditionalModuleName(String additionalModuleName) {
        if (StringUtils.isNotBlank((String)additionalModuleName)) {
            this.additionalModuleNames.remove(additionalModuleName.trim());
        }
    }

    public List<String> getArgs() {
        return this.args;
    }

    public void setArgs(List<String> args) {
        this.args.clear();
        this.args.addAll(args);
    }

    public void addArgs(List<String> args) {
        this.args.addAll(args);
    }

    public void addArg(String arg) {
        if (StringUtils.isNotBlank((String)arg)) {
            this.args.add(arg.trim());
        }
    }

    public void removeArg(String arg) {
        if (StringUtils.isNotBlank((String)arg)) {
            this.args.remove(arg.trim());
        }
    }

    public Boolean isCopyJars() {
        return this.copyJars == null || this.copyJars != false;
    }

    public void setCopyJars(Boolean copyJars) {
        this.copyJars = copyJars;
    }

    public boolean isCopyJarsSet() {
        return this.copyJars != null;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("imageName", this.imageName);
        props.put("imageNameTransform", this.imageNameTransform);
        props.put("moduleNames", this.moduleNames);
        props.put("additionalModuleNames", this.additionalModuleNames);
        props.put("args", this.args);
        props.put("jdeps", this.jdeps.asMap(full));
        LinkedHashMap<String, Map<String, Object>> mappedJdks = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (Artifact targetJdk : this.getTargetJdks()) {
            mappedJdks.put("jdk " + i++, targetJdk.asMap(full));
        }
        props.put("jdk", this.jdk.asMap(full));
        props.put("targetJdks", mappedJdks);
        props.put("copyJars", this.isCopyJars());
    }

    public static class Jdeps
    implements Domain {
        private final Set<String> targets = new LinkedHashSet<String>();
        private String multiRelease;
        private Boolean ignoreMissingDeps;
        private Boolean useWildcardInPath;

        void setAll(Jdeps jdeps) {
            this.multiRelease = jdeps.multiRelease;
            this.ignoreMissingDeps = jdeps.ignoreMissingDeps;
            this.useWildcardInPath = jdeps.useWildcardInPath;
            this.setTargets(jdeps.targets);
        }

        public String getMultiRelease() {
            return this.multiRelease;
        }

        public void setMultiRelease(String multiRelease) {
            this.multiRelease = multiRelease;
        }

        public Boolean isIgnoreMissingDeps() {
            return this.ignoreMissingDeps != null && this.ignoreMissingDeps != false;
        }

        public void setIgnoreMissingDeps(Boolean ignoreMissingDeps) {
            this.ignoreMissingDeps = ignoreMissingDeps;
        }

        public boolean isIgnoreMissingDepsSet() {
            return this.ignoreMissingDeps != null;
        }

        public Boolean isUseWildcardInPath() {
            return this.useWildcardInPath == null || this.useWildcardInPath != false;
        }

        public void setUseWildcardInPath(Boolean useWildcardInPath) {
            this.useWildcardInPath = useWildcardInPath;
        }

        public boolean isUseWildcardInPathSet() {
            return this.useWildcardInPath != null;
        }

        public Set<String> getTargets() {
            return this.targets;
        }

        public void setTargets(Set<String> targets) {
            this.targets.clear();
            this.targets.addAll(targets);
        }

        public void addTargets(List<String> targets) {
            this.targets.addAll(targets);
        }

        public void addTarget(String target) {
            if (StringUtils.isNotBlank((String)target)) {
                this.targets.add(target.trim());
            }
        }

        public void removeTarget(String target) {
            if (StringUtils.isNotBlank((String)target)) {
                this.targets.remove(target.trim());
            }
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("multiRelease", this.multiRelease);
            props.put("ignoreMissingDeps", this.isIgnoreMissingDeps());
            props.put("useWildcardInPath", this.isUseWildcardInPath());
            props.put("targets", this.targets);
            return props;
        }
    }
}

