/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.mattermost;

import java.util.LinkedHashMap;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Mattermost;
import org.jreleaser.model.announcer.spi.AnnounceException;
import org.jreleaser.model.announcer.spi.Announcer;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.mattermost.Message;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.StringUtils;

public class MattermostAnnouncer
implements Announcer {
    private final JReleaserContext context;

    MattermostAnnouncer(JReleaserContext context) {
        this.context = context;
    }

    public String getName() {
        return "mattermost";
    }

    public boolean isEnabled() {
        return this.context.getModel().getAnnounce().getMattermost().isEnabled();
    }

    public void announce() throws AnnounceException {
        Mattermost mattermost = this.context.getModel().getAnnounce().getMattermost();
        String message = "";
        if (StringUtils.isNotBlank((String)mattermost.getMessage())) {
            message = mattermost.getResolvedMessage(this.context);
        } else {
            LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
            props.put("changelog", MustacheUtils.passThrough((String)this.context.getChangelog()));
            this.context.getModel().getRelease().getGitService().fillProps(props, this.context.getModel());
            message = mattermost.getResolvedMessageTemplate(this.context, props);
        }
        this.context.getLogger().info("message: {}", new Object[]{message});
        if (!this.context.isDryrun()) {
            ClientUtils.webhook((JReleaserLogger)this.context.getLogger(), (String)mattermost.getResolvedWebhook(), (int)mattermost.getConnectTimeout(), (int)mattermost.getReadTimeout(), (Object)Message.of(message));
        }
    }
}

