/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.upload;

import java.util.Objects;
import org.jreleaser.bundle.RB;
import org.jreleaser.engine.upload.ArtifactUploaders;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Uploader;
import org.jreleaser.model.uploader.spi.ArtifactUploader;
import org.jreleaser.model.uploader.spi.UploadException;

public class ProjectUploader {
    private final JReleaserContext context;
    private final Uploader uploader;

    private ProjectUploader(JReleaserContext context, Uploader uploader) {
        this.context = context;
        this.uploader = uploader;
    }

    public Uploader getUploader() {
        return this.uploader;
    }

    public void upload() throws UploadException {
        if (!this.uploader.isEnabled()) {
            this.context.getLogger().debug(RB.$((String)"uploaders.skip.upload", (Object[])new Object[0]), new Object[]{this.uploader.getName()});
            return;
        }
        ArtifactUploader<Uploader> artifactUploader = ArtifactUploaders.findUploader(this.context, this.uploader);
        this.context.getLogger().info(RB.$((String)"uploaders.upload.to", (Object[])new Object[0]), new Object[]{this.uploader.getName()});
        artifactUploader.upload(this.uploader.getName());
    }

    public static ProjectUploaderBuilder builder() {
        return new ProjectUploaderBuilder();
    }

    public static class ProjectUploaderBuilder {
        private JReleaserContext context;
        private Uploader uploader;

        public ProjectUploaderBuilder context(JReleaserContext context) {
            this.context = Objects.requireNonNull(context, "'context' must not be null");
            return this;
        }

        public ProjectUploaderBuilder uploader(Uploader uploader) {
            this.uploader = Objects.requireNonNull(uploader, "'uploader' must not be null");
            return this;
        }

        public ProjectUploader build() {
            Objects.requireNonNull(this.context, "'context' must not be null");
            Objects.requireNonNull(this.uploader, "'uploader' must not be null");
            return new ProjectUploader(this.context, this.uploader);
        }
    }
}

