/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.util.Collections;
import java.util.Set;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.model.Macports;
import org.jreleaser.model.MacportsRepository;
import org.jreleaser.model.validation.DistributionsValidator;
import org.jreleaser.model.validation.ExtraPropertiesValidator;
import org.jreleaser.model.validation.TemplateValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Algorithm;
import org.jreleaser.util.Errors;

public abstract class MacportsValidator
extends Validator {
    public static void validateMacports(JReleaserContext context, Distribution distribution, Macports tool, Errors errors) {
        JReleaserModel model = context.getModel();
        Macports parentTool = model.getPackagers().getMacports();
        if (!tool.isActiveSet() && parentTool.isActiveSet()) {
            tool.setActive(parentTool.getActive());
        }
        if (!tool.resolveEnabled(context.getModel().getProject(), distribution)) {
            tool.disable();
            return;
        }
        GitService service = model.getRelease().getGitService();
        if (!service.isReleaseSupported()) {
            tool.disable();
            return;
        }
        context.getLogger().debug("distribution.{}.macports", new Object[]{distribution.getName()});
        if (null == tool.getRevision()) {
            tool.setRevision(parentTool.getRevision());
        }
        if (null == tool.getRevision()) {
            tool.setRevision(0);
        }
        if (tool.getMaintainers().isEmpty()) {
            tool.setMaintainers(parentTool.getMaintainers());
        }
        if (tool.getCategories().isEmpty()) {
            tool.setCategories(parentTool.getCategories());
        }
        if (tool.getCategories().isEmpty()) {
            tool.setCategories(Collections.singletonList("devel"));
        }
        MacportsValidator.validateCommitAuthor(tool, parentTool);
        MacportsRepository repository = tool.getRepository();
        repository.resolveEnabled(model.getProject());
        MacportsValidator.validateTap(context, distribution, repository, parentTool.getRepository(), "macports.repository");
        TemplateValidator.validateTemplate(context, distribution, tool, parentTool, errors);
        ExtraPropertiesValidator.mergeExtraProperties(tool, parentTool);
        MacportsValidator.validateContinueOnError(tool, parentTool);
        DistributionsValidator.validateArtifactPlatforms(context, distribution, tool, errors);
        Set<String> fileExtensions = tool.getSupportedExtensions();
        long count = distribution.getArtifacts().stream().filter(Artifact::isActive).filter(artifact -> fileExtensions.stream().anyMatch(ext -> artifact.getPath().endsWith((String)ext))).filter(artifact -> tool.supportsPlatform(artifact.getPlatform())).count();
        if (count > 0L) {
            context.getModel().getChecksum().getAlgorithms().add(Algorithm.RMD160);
        }
    }
}

