/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Archive;
import org.jreleaser.model.Assemble;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Jlink;
import org.jreleaser.model.NativeImage;
import org.jreleaser.model.validation.ArchiveValidator;
import org.jreleaser.model.validation.JlinkValidator;
import org.jreleaser.model.validation.NativeImageValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;

public abstract class AssemblersValidator
extends Validator {
    public static void validateAssemblers(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        List types2;
        if (mode == JReleaserContext.Mode.CHANGELOG) {
            return;
        }
        context.getLogger().debug("assemble");
        Assemble assemble = context.getModel().getAssemble();
        ArchiveValidator.validateArchive(context, mode, errors);
        JlinkValidator.validateJlink(context, mode, errors);
        NativeImageValidator.validateNativeImage(context, mode, errors);
        LinkedHashMap<String, List> byDistributionName = new LinkedHashMap<String, List>();
        for (Archive archive : assemble.getActiveArchives()) {
            types2 = byDistributionName.computeIfAbsent(archive.getName(), k -> new ArrayList());
            types2.add(archive.getType());
        }
        for (Jlink jlink : assemble.getActiveJlinks()) {
            types2 = byDistributionName.computeIfAbsent(jlink.getName(), k -> new ArrayList());
            types2.add(jlink.getType());
        }
        for (NativeImage nativeImage : assemble.getActiveNativeImages()) {
            types2 = byDistributionName.computeIfAbsent(nativeImage.getName(), k -> new ArrayList());
            types2.add(nativeImage.getType());
        }
        byDistributionName.forEach((name, types) -> {
            if (types.size() > 1) {
                errors.configuration(RB.$((String)"validation_multiple_assemblers", (Object[])new Object[]{"distribution." + name, types}));
                assemble.setEnabled(false);
            }
        });
        if (!assemble.isEnabledSet()) {
            assemble.setEnabled(!assemble.getActiveArchives().isEmpty() || !assemble.getActiveJlinks().isEmpty() || !assemble.getActiveNativeImages().isEmpty());
        }
    }
}

