/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.io.File;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Article;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Repository;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Env;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class ArticleValidator
extends Validator {
    public static void validateArticle(JReleaserContext context, Article article, Errors errors) {
        File templateDirectoryFile;
        if (!article.resolveEnabled(context.getModel().getProject())) {
            return;
        }
        context.getLogger().debug("announce.article");
        GitService service = context.getModel().getRelease().getGitService();
        Repository repository = article.getRepository();
        ArticleValidator.validateCommitAuthor(article, service);
        ArticleValidator.validateOwner(repository, service);
        if (StringUtils.isBlank((String)repository.getName())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"announce.article.repository.name"}));
        }
        if (StringUtils.isBlank((String)article.getRepository().getCommitMessage())) {
            article.getRepository().setCommitMessage("{{projectName}} {{tagName}}");
        }
        repository.setUsername(ArticleValidator.checkProperty(context, Env.toVar((String)(repository.getBasename() + "_" + service.getServiceName())) + "_USERNAME", "announce.article.repository.username", repository.getUsername(), service.getResolvedUsername()));
        repository.setToken(ArticleValidator.checkProperty(context, Env.toVar((String)(repository.getBasename() + "_" + service.getServiceName())) + "_TOKEN", "announce.article.repository.token", repository.getToken(), service.getResolvedToken()));
        repository.setBranch(ArticleValidator.checkProperty(context, Env.toVar((String)(repository.getBasename() + "_" + service.getServiceName())) + "_BRANCH", "announce.article.repository.branch", repository.getBranch(), "HEAD"));
        if (StringUtils.isBlank((String)article.getTemplateDirectory())) {
            article.setTemplateDirectory("src/jreleaser/templates/article");
        }
        if (!(templateDirectoryFile = context.getBasedir().resolve(article.getTemplateDirectory().trim()).toFile()).exists()) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"announce.article.templateDirectory", article.getTemplateDirectory()}));
        }
        if (!templateDirectoryFile.isDirectory()) {
            errors.configuration(RB.$((String)"validation_is_not_a_directory", (Object[])new Object[]{"announce.article.templateDirectory", article.getTemplateDirectory()}));
        }
        if (templateDirectoryFile.listFiles() == null || templateDirectoryFile.listFiles().length == 0) {
            errors.configuration(RB.$((String)"validation_directory_is_empty", (Object[])new Object[]{"announce.article.templateDirectory", article.getTemplateDirectory()}));
        }
        if (article.getFiles().isEmpty()) {
            errors.configuration(RB.$((String)"validation_must_not_be_empty", (Object[])new Object[]{"announce.article.files"}));
        }
    }
}

