/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jreleaser.model.AbstractRepositoryTool;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Github;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.MacportsRepository;
import org.jreleaser.model.RepositoryTap;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public class Macports
extends AbstractRepositoryTool {
    public static final String NAME = "macports";
    private final List<String> categories = new ArrayList<String>();
    private final List<String> maintainers = new ArrayList<String>();
    private final MacportsRepository repository = new MacportsRepository();
    private Integer revision;

    public Macports() {
        super(NAME);
    }

    void setAll(Macports macports) {
        super.setAll(macports);
        this.revision = macports.revision;
        this.setRepository(macports.repository);
        this.setCategories(macports.categories);
        this.setMaintainers(macports.maintainers);
    }

    public List<String> getResolvedMaintainers(JReleaserContext context) {
        String maintainer;
        Github github;
        if (this.maintainers.isEmpty() && (github = context.getModel().getRelease().getGithub()) != null && StringUtils.isNotBlank((String)(maintainer = github.getResolvedUsername()))) {
            this.maintainers.add("@" + maintainer);
        }
        return this.maintainers;
    }

    public Integer getRevision() {
        return this.revision;
    }

    public void setRevision(Integer revision) {
        this.revision = revision;
    }

    public MacportsRepository getRepository() {
        return this.repository;
    }

    public void setRepository(MacportsRepository repository) {
        this.repository.setAll(repository);
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public void setCategories(List<String> categories) {
        this.categories.clear();
        this.categories.addAll(categories);
    }

    public List<String> getMaintainers() {
        return this.maintainers;
    }

    public void setMaintainers(List<String> maintainers) {
        this.maintainers.clear();
        this.maintainers.addAll(maintainers);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("revision", this.revision);
        props.put("categories", this.categories);
        props.put("maintainers", this.maintainers);
        props.put("repository", this.repository.asMap(full));
    }

    @Override
    public RepositoryTap getRepositoryTap() {
        return this.repository;
    }

    @Override
    public boolean supportsPlatform(String platform) {
        return StringUtils.isBlank((String)platform) || PlatformUtils.isMac((String)platform);
    }

    @Override
    public boolean supportsDistribution(Distribution distribution) {
        return distribution.getType() == Distribution.DistributionType.JAVA_BINARY || distribution.getType() == Distribution.DistributionType.NATIVE_IMAGE;
    }
}

