/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jreleaser.model.AbstractRepositoryTool;
import org.jreleaser.model.Cask;
import org.jreleaser.model.HomebrewTap;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.RepositoryTap;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public class Brew
extends AbstractRepositoryTool {
    public static final String NAME = "brew";
    private final List<Dependency> dependencies = new ArrayList<Dependency>();
    private final List<String> livecheck = new ArrayList<String>();
    private final HomebrewTap tap = new HomebrewTap();
    private final Cask cask = new Cask();
    private String formulaName;
    private String cachedFormulaName;
    private Boolean multiPlatform;

    public Brew() {
        super(NAME);
    }

    void setAll(Brew brew) {
        super.setAll(brew);
        this.formulaName = brew.formulaName;
        this.multiPlatform = brew.multiPlatform;
        this.setTap(brew.tap);
        this.setDependenciesAsList(brew.dependencies);
        this.setLivecheck(brew.livecheck);
        this.setCask(brew.cask);
    }

    public String getResolvedFormulaName(JReleaserContext context) {
        if (StringUtils.isBlank((String)this.cachedFormulaName)) {
            this.cachedFormulaName = this.formulaName.contains("{{") ? MustacheUtils.applyTemplate((String)this.formulaName, context.props()) : this.formulaName;
            this.cachedFormulaName = StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)this.cachedFormulaName);
        }
        return this.cachedFormulaName;
    }

    public String getResolvedFormulaName(Map<String, Object> props) {
        if (StringUtils.isBlank((String)this.cachedFormulaName)) {
            this.cachedFormulaName = this.formulaName.contains("{{") ? MustacheUtils.applyTemplate((String)this.formulaName, props) : this.formulaName;
            this.cachedFormulaName = StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)this.cachedFormulaName);
        } else if (this.cachedFormulaName.contains("{{")) {
            this.cachedFormulaName = MustacheUtils.applyTemplate((String)this.cachedFormulaName, props);
            this.cachedFormulaName = StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)this.cachedFormulaName);
        }
        return this.cachedFormulaName;
    }

    public String getFormulaName() {
        return this.formulaName;
    }

    public void setFormulaName(String formulaName) {
        this.formulaName = formulaName;
    }

    public boolean isMultiPlatform() {
        return this.multiPlatform != null && this.multiPlatform != false;
    }

    public void setMultiPlatform(Boolean multiPlatform) {
        this.multiPlatform = multiPlatform;
    }

    public boolean isMultiPlatformSet() {
        return this.multiPlatform != null;
    }

    public HomebrewTap getTap() {
        return this.tap;
    }

    public void setTap(HomebrewTap tap) {
        this.tap.setAll(tap);
    }

    public Cask getCask() {
        return this.cask;
    }

    public void setCask(Cask cask) {
        this.cask.setAll(cask);
    }

    public void setDependencies(Map<String, String> dependencies) {
        if (null == dependencies || dependencies.isEmpty()) {
            return;
        }
        this.dependencies.clear();
        dependencies.forEach(this::addDependency);
    }

    public List<Dependency> getDependenciesAsList() {
        return this.dependencies;
    }

    public void setDependenciesAsList(List<Dependency> dependencies) {
        if (null == dependencies || dependencies.isEmpty()) {
            return;
        }
        this.dependencies.clear();
        this.dependencies.addAll(dependencies);
    }

    public void addDependencies(Map<String, String> dependencies) {
        if (null == dependencies || dependencies.isEmpty()) {
            return;
        }
        dependencies.forEach(this::addDependency);
    }

    public void addDependency(String key, String value) {
        this.dependencies.add(new Dependency(key, value));
    }

    public void addDependency(String key) {
        this.dependencies.add(new Dependency(key));
    }

    public List<String> getLivecheck() {
        return this.livecheck;
    }

    public void setLivecheck(List<String> livecheck) {
        this.livecheck.clear();
        this.livecheck.addAll(livecheck);
    }

    public boolean hasLivecheck() {
        return !this.livecheck.isEmpty();
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("formulaName", this.formulaName);
        props.put("multiPlatform", this.isMultiPlatform());
        props.put("tap", this.tap.asMap(full));
        props.put("dependencies", this.dependencies);
        props.put("livecheck", this.livecheck);
        props.put("cask", this.cask.asMap(full));
    }

    @Override
    public RepositoryTap getRepositoryTap() {
        return this.tap;
    }

    @Override
    public boolean supportsPlatform(String platform) {
        if (this.isMultiPlatform()) {
            return (StringUtils.isBlank((String)platform) || PlatformUtils.isMac((String)platform) || PlatformUtils.isLinux((String)platform)) && !PlatformUtils.isAlpineLinux((String)platform);
        }
        return StringUtils.isBlank((String)platform) || PlatformUtils.isMac((String)platform);
    }

    @Override
    public Set<String> getSupportedExtensions() {
        LinkedHashSet<String> extensions = new LinkedHashSet<String>();
        extensions.add(".dmg");
        extensions.add(".pkg");
        extensions.add(".zip");
        extensions.add(".jar");
        return extensions;
    }

    public static class Dependency {
        private final String key;
        private final String value;

        private Dependency(String key) {
            this(key, (String)null);
        }

        private Dependency(String key, String value) {
            this.key = key;
            this.value = StringUtils.isBlank((String)value) || "null".equalsIgnoreCase(value) ? null : value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            StringBuilder formatted = new StringBuilder();
            if (this.key.startsWith(":")) {
                formatted.append(this.key);
            } else {
                formatted.append("\"").append(this.key).append("\"");
            }
            if (StringUtils.isNotBlank((String)this.value)) {
                formatted.append(" => \"").append(this.value).append("\"");
            }
            return formatted.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Dependency that = (Dependency)o;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }
    }
}

