/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.teams;

import java.util.LinkedHashMap;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Teams;
import org.jreleaser.model.announcer.spi.AnnounceException;
import org.jreleaser.model.announcer.spi.Announcer;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.MustacheUtils;

public class TeamsAnnouncer
implements Announcer {
    private final JReleaserContext context;

    TeamsAnnouncer(JReleaserContext context) {
        this.context = context;
    }

    public String getName() {
        return "teams";
    }

    public boolean isEnabled() {
        return this.context.getModel().getAnnounce().getTeams().isEnabled();
    }

    public void announce() throws AnnounceException {
        Teams teams = this.context.getModel().getAnnounce().getTeams();
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        props.put("changelog", MustacheUtils.passThrough((String)TeamsAnnouncer.convertLineEndings(this.context.getChangelog())));
        this.context.getModel().getRelease().getGitService().fillProps(props, this.context.getModel());
        String message = teams.getResolvedMessageTemplate(this.context, props);
        this.context.getLogger().info(RB.$((String)"webhook.message.send", (Object[])new Object[0]));
        if (!this.context.isDryrun()) {
            ClientUtils.webhook((JReleaserLogger)this.context.getLogger(), (String)teams.getResolvedWebhook(), (int)teams.getConnectTimeout(), (int)teams.getReadTimeout(), (String)message);
        }
    }

    public static String convertLineEndings(String str) {
        return str.replaceAll("\\n", "\\\\n\\\\n");
    }
}

