/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.cli;

import org.jreleaser.cli.AbstractModelCommand;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.workflow.Workflows;
import picocli.CommandLine;

@CommandLine.Command(name="assemble")
public class Assemble
extends AbstractModelCommand {
    @CommandLine.ArgGroup
    Composite composite;

    @Override
    protected void doExecute(JReleaserContext context) {
        if (null != this.composite) {
            context.setIncludedAssemblers(this.collectEntries(this.composite.includedAssemblers(), true));
            context.setIncludedDistributions(this.collectEntries(this.composite.includedDistributions()));
            context.setExcludedAssemblers(this.collectEntries(this.composite.excludedAssemblers(), true));
            context.setExcludedDistributions(this.collectEntries(this.composite.excludedDistributions()));
        }
        Workflows.assemble((JReleaserContext)context).execute();
    }

    @Override
    protected JReleaserContext.Mode getMode() {
        return JReleaserContext.Mode.ASSEMBLE;
    }

    static class Exclude {
        @CommandLine.Option(names={"-xa", "--exclude-assembler"}, paramLabel="<assembler>")
        String[] excludedAssemblers;
        @CommandLine.Option(names={"-xd", "--exclude-distribution"}, paramLabel="<distribution>")
        String[] excludedDistributions;

        Exclude() {
        }
    }

    static class Include {
        @CommandLine.Option(names={"-a", "--assembler"}, paramLabel="<assembler>")
        String[] includedAssemblers;
        @CommandLine.Option(names={"-d", "--distribution"}, paramLabel="<distribution>")
        String[] includedDistributions;

        Include() {
        }
    }

    static class Composite {
        @CommandLine.ArgGroup(exclusive=false, order=1, headingKey="include.filter.header")
        Include include;
        @CommandLine.ArgGroup(exclusive=false, order=2, headingKey="exclude.filter.header")
        Exclude exclude;

        Composite() {
        }

        String[] includedAssemblers() {
            return this.include != null ? this.include.includedAssemblers : null;
        }

        String[] includedDistributions() {
            return this.include != null ? this.include.includedDistributions : null;
        }

        String[] excludedAssemblers() {
            return this.exclude != null ? this.exclude.excludedAssemblers : null;
        }

        String[] excludedDistributions() {
            return this.exclude != null ? this.exclude.excludedDistributions : null;
        }
    }
}

