/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.twitter;

import org.jreleaser.sdk.twitter.AbstractTwitterCommand;
import org.jreleaser.sdk.twitter.TwitterException;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.StringUtils;

public class UpdateStatusTwitterCommand
extends AbstractTwitterCommand {
    private final String status;

    private UpdateStatusTwitterCommand(JReleaserLogger logger, String apiHost, int connectTimeout, int readTimeout, String consumerKey, String consumerToken, String accessToken, String accessTokenSecret, boolean dryrun, String status) {
        super(logger, apiHost, connectTimeout, readTimeout, consumerKey, consumerToken, accessToken, accessTokenSecret, dryrun);
        this.status = status;
    }

    @Override
    public void execute() throws TwitterException {
        this.twitter.updateStatus(this.status);
    }

    public static Builder builder(JReleaserLogger logger) {
        return new Builder(logger);
    }

    public static class Builder
    extends AbstractTwitterCommand.Builder<Builder> {
        private String status;

        protected Builder(JReleaserLogger logger) {
            super(logger);
        }

        public Builder status(String status) {
            this.status = StringUtils.requireNonBlank((String)status, (String)"'status' must not be blank");
            return this;
        }

        public UpdateStatusTwitterCommand build() {
            this.validate();
            StringUtils.requireNonBlank((String)this.status, (String)"'status' must not be blank");
            return new UpdateStatusTwitterCommand(this.logger, this.apiHost, this.connectTimeout, this.readTimeout, this.consumerKey, this.consumerToken, this.accessToken, this.accessTokenSecret, this.dryrun, this.status);
        }
    }
}

