/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.util.InvalidVersionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class VersionRetriever
implements EntityResolver,
ErrorHandler {
    private static final String VERSION_3 = "3.0";
    private static final String VERSION_2 = "2.0";
    private final Report report;
    private final String path;

    public VersionRetriever(String path, Report report) {
        this.path = path;
        this.report = report;
    }

    public EPUBVersion retrieveOpfVersion(InputStream inputStream) throws InvalidVersionException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            SAXParser parser = factory.newSAXParser();
            parser.getXMLReader().setEntityResolver(this);
            parser.getXMLReader().setErrorHandler(this);
            parser.getXMLReader().setContentHandler(new OPFhandler());
            parser.getXMLReader().parse(new InputSource(inputStream));
        }
        catch (ParserConfigurationException e) {
            this.report.message(MessageId.RSC_005, EPUBLocation.create(this.path), e.getMessage());
        }
        catch (SAXException e) {
            if (VERSION_3.equals(e.getMessage())) {
                this.report.info(null, FeatureEnum.FORMAT_VERSION, EPUBVersion.VERSION_3.toString());
                return EPUBVersion.VERSION_3;
            }
            if (VERSION_2.equals(e.getMessage())) {
                this.report.info(null, FeatureEnum.FORMAT_VERSION, EPUBVersion.VERSION_2.toString());
                return EPUBVersion.VERSION_2;
            }
            if ("Version not supported".equals(e.getMessage())) {
                throw new InvalidVersionException("Version not supported");
            }
            if ("Version attribute not found".equals(e.getMessage())) {
                throw new InvalidVersionException("Version attribute not found");
            }
            if ("Package element must be the first element in the package file".equals(e.getMessage())) {
                throw new InvalidVersionException("Package element must be the first element in the package file");
            }
            this.report.message(MessageId.RSC_005, EPUBLocation.create(this.path), e.getMessage());
        }
        catch (IOException e) {
            this.report.message(MessageId.PKG_008, EPUBLocation.create(this.path), this.path);
        }
        throw new InvalidVersionException("Version not found");
    }

    @Override
    public InputSource resolveEntity(String arg0, String arg1) throws SAXException, IOException {
        return new InputSource(new StringReader(""));
    }

    @Override
    public void error(SAXParseException arg0) throws SAXException {
    }

    @Override
    public void fatalError(SAXParseException arg0) throws SAXException {
    }

    @Override
    public void warning(SAXParseException arg0) throws SAXException {
    }

    private class OPFhandler
    extends DefaultHandler {
        private OPFhandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!"package".equals(localName)) {
                throw new SAXException("Package element must be the first element in the package file");
            }
            this.processPackage(attributes);
        }

        private void processPackage(Attributes attributes) throws SAXException {
            String version = attributes.getValue("version");
            if (version == null) {
                throw new SAXException("Version attribute not found");
            }
            if (VersionRetriever.VERSION_3.equals(version)) {
                throw new SAXException(VersionRetriever.VERSION_3);
            }
            if (VersionRetriever.VERSION_2.equals(version)) {
                throw new SAXException(VersionRetriever.VERSION_2);
            }
            throw new SAXException("Version not supported");
        }
    }
}

