/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.diff.tag;

import org.outerj.daisy.diff.output.TextDiffOutput;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class TagSaxDiffOutput
implements TextDiffOutput {
    private ContentHandler consumer;
    private boolean insideTag = false;
    private int removedID = 1;
    private int addedID = 1;

    public TagSaxDiffOutput(ContentHandler contentHandler) throws SAXException {
        this.consumer = contentHandler;
    }

    @Override
    public void addClearPart(String string) throws Exception {
        this.addBasicText(string);
    }

    private void addBasicText(String string) throws SAXException {
        char[] cArray = string.toCharArray();
        AttributesImpl attributesImpl = new AttributesImpl();
        block5: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '\n': {
                    this.consumer.startElement("", "br", "br", attributesImpl);
                    this.consumer.endElement("", "br", "br");
                    this.consumer.characters("\n".toCharArray(), 0, "\n".length());
                    continue block5;
                }
                case '<': {
                    if (!this.insideTag) {
                        AttributesImpl attributesImpl2 = new AttributesImpl();
                        attributesImpl2.addAttribute("", "class", "class", "CDATA", "diff-tag-html");
                        this.consumer.startElement("", "span", "span", attributesImpl2);
                        this.insideTag = true;
                    } else {
                        this.consumer.endElement("", "span", "span");
                        this.insideTag = false;
                    }
                    this.consumer.characters("<".toCharArray(), 0, "<".length());
                    continue block5;
                }
                case '>': {
                    this.consumer.characters(">".toCharArray(), 0, ">".length());
                    if (!this.insideTag) continue block5;
                    this.consumer.endElement("", "span", "span");
                    this.insideTag = false;
                    continue block5;
                }
                default: {
                    this.consumer.characters(cArray, i, 1);
                }
            }
        }
    }

    @Override
    public void addRemovedPart(String string) throws Exception {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "class", "class", "CDATA", "diff-tag-removed");
        attributesImpl.addAttribute("", "id", "id", "CDATA", "removed" + this.removedID);
        attributesImpl.addAttribute("", "title", "title", "CDATA", "#removed" + this.removedID);
        ++this.removedID;
        this.consumer.startElement("", "span", "span", attributesImpl);
        this.addBasicText(string);
        this.consumer.endElement("", "span", "span");
    }

    @Override
    public void addAddedPart(String string) throws Exception {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "class", "class", "CDATA", "diff-tag-added");
        attributesImpl.addAttribute("", "id", "id", "CDATA", "added" + this.addedID);
        attributesImpl.addAttribute("", "title", "title", "CDATA", "#added" + this.addedID);
        ++this.addedID;
        this.consumer.startElement("", "span", "span", attributesImpl);
        this.addBasicText(string);
        this.consumer.endElement("", "span", "span");
    }
}

