/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.schema;

import cz.startnet.utils.pgdiff.PgDiffUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class PgFunction {
    private String name;
    private final List<Argument> arguments = new ArrayList<Argument>();
    private String body;
    private String comment;

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getCreationSQL() {
        StringBuilder sbSQL = new StringBuilder(500);
        sbSQL.append("CREATE OR REPLACE FUNCTION ");
        sbSQL.append(PgDiffUtils.getQuotedName(this.name));
        sbSQL.append('(');
        boolean addComma = false;
        for (Argument argument : this.arguments) {
            if (addComma) {
                sbSQL.append(", ");
            }
            sbSQL.append(argument.getDeclaration(true));
            addComma = true;
        }
        sbSQL.append(") ");
        sbSQL.append(this.body);
        sbSQL.append(';');
        if (this.comment != null && !this.comment.isEmpty()) {
            sbSQL.append("\n\nCOMMENT ON FUNCTION ");
            sbSQL.append(PgDiffUtils.getQuotedName(this.name));
            sbSQL.append('(');
            addComma = false;
            for (Argument argument : this.arguments) {
                if (addComma) {
                    sbSQL.append(", ");
                }
                sbSQL.append(argument.getDeclaration(false));
                addComma = true;
            }
            sbSQL.append(") IS ");
            sbSQL.append(this.comment);
            sbSQL.append(';');
        }
        return sbSQL.toString();
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getBody() {
        return this.body;
    }

    public String getDropSQL() {
        StringBuilder sbString = new StringBuilder(100);
        sbString.append("DROP FUNCTION ");
        sbString.append(this.name);
        sbString.append('(');
        boolean addComma = false;
        for (Argument argument : this.arguments) {
            if ("OUT".equalsIgnoreCase(argument.getMode())) continue;
            if (addComma) {
                sbString.append(", ");
            }
            sbString.append(argument.getDeclaration(false));
            addComma = true;
        }
        sbString.append(");");
        return sbString.toString();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<Argument> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    public void addArgument(Argument argument) {
        this.arguments.add(argument);
    }

    public String getSignature() {
        StringBuilder sbString = new StringBuilder(100);
        sbString.append(this.name);
        sbString.append('(');
        boolean addComma = false;
        for (Argument argument : this.arguments) {
            if ("OUT".equalsIgnoreCase(argument.getMode())) continue;
            if (addComma) {
                sbString.append(',');
            }
            sbString.append(argument.getDataType().toLowerCase(Locale.ENGLISH));
            addComma = true;
        }
        sbString.append(')');
        return sbString.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof PgFunction)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        return this.equals(object, false);
    }

    public boolean equals(Object object, boolean ignoreFunctionWhitespace) {
        boolean equals = false;
        if (this == object) {
            equals = true;
        } else if (object instanceof PgFunction) {
            String thatBody;
            String thisBody;
            PgFunction function = (PgFunction)object;
            if (this.name == null && function.getName() != null || this.name != null && !this.name.equals(function.getName())) {
                return false;
            }
            if (ignoreFunctionWhitespace) {
                thisBody = this.body.replaceAll("\\s+", " ");
                thatBody = function.getBody().replaceAll("\\s+", " ");
            } else {
                thisBody = this.body;
                thatBody = function.getBody();
            }
            if (thisBody == null && thatBody != null || thisBody != null && !thisBody.equals(thatBody)) {
                return false;
            }
            if (this.arguments.size() != function.getArguments().size()) {
                return false;
            }
            for (int i = 0; i < this.arguments.size(); ++i) {
                if (this.arguments.get(i).equals(function.getArguments().get(i))) continue;
                return false;
            }
            return true;
        }
        return equals;
    }

    public int hashCode() {
        StringBuilder sbString = new StringBuilder(500);
        sbString.append(this.body);
        sbString.append('|');
        sbString.append(this.name);
        for (Argument argument : this.arguments) {
            sbString.append('|');
            sbString.append(argument.getDeclaration(true));
        }
        return sbString.toString().hashCode();
    }

    public static class Argument {
        private String mode = "IN";
        private String name;
        private String dataType;
        private String defaultExpression;

        public String getDataType() {
            return this.dataType;
        }

        public void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public String getDefaultExpression() {
            return this.defaultExpression;
        }

        public void setDefaultExpression(String defaultExpression) {
            this.defaultExpression = defaultExpression;
        }

        public String getMode() {
            return this.mode;
        }

        public void setMode(String mode) {
            this.mode = mode == null || mode.isEmpty() ? "IN" : mode;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDeclaration(boolean includeDefaultValue) {
            StringBuilder sbString = new StringBuilder(50);
            if (this.mode != null && !"IN".equalsIgnoreCase(this.mode)) {
                sbString.append(this.mode);
                sbString.append(' ');
            }
            if (this.name != null && !this.name.isEmpty()) {
                sbString.append(PgDiffUtils.getQuotedName(this.name));
                sbString.append(' ');
            }
            sbString.append(this.dataType);
            if (includeDefaultValue && this.defaultExpression != null && !this.defaultExpression.isEmpty()) {
                sbString.append(" = ");
                sbString.append(this.defaultExpression);
            }
            return sbString.toString();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Argument)) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            Argument argument = (Argument)obj;
            return (this.dataType == null ? argument.getDataType() == null : this.dataType.equalsIgnoreCase(argument.getDataType())) && (this.defaultExpression == null ? argument.getDefaultExpression() == null : this.defaultExpression.equals(this.defaultExpression)) && (this.mode == null ? argument.getMode() == null : this.mode.equalsIgnoreCase(argument.getMode())) && (this.name == null ? argument.getName() == null : this.name.equals(argument.getName()));
        }

        public int hashCode() {
            StringBuilder sbString = new StringBuilder(50);
            sbString.append(this.mode == null ? null : this.mode.toUpperCase(Locale.ENGLISH));
            sbString.append('|');
            sbString.append(this.name);
            sbString.append('|');
            sbString.append(this.dataType == null ? null : this.dataType.toUpperCase(Locale.ENGLISH));
            sbString.append('|');
            sbString.append(this.defaultExpression);
            return sbString.toString().hashCode();
        }
    }
}

