/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff;

import cz.startnet.utils.pgdiff.PgDiffUtils;
import cz.startnet.utils.pgdiff.SearchPathHelper;
import cz.startnet.utils.pgdiff.schema.PgConstraint;
import cz.startnet.utils.pgdiff.schema.PgSchema;
import cz.startnet.utils.pgdiff.schema.PgTable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class PgDiffConstraints {
    public static void createConstraints(PrintWriter writer, PgSchema oldSchema, PgSchema newSchema, boolean primaryKey, SearchPathHelper searchPathHelper) {
        for (PgTable newTable : newSchema.getTables()) {
            PgTable oldTable = oldSchema == null ? null : oldSchema.getTable(newTable.getName());
            for (PgConstraint constraint : PgDiffConstraints.getNewConstraints(oldTable, newTable, primaryKey)) {
                searchPathHelper.outputSearchPath(writer);
                writer.println();
                writer.println(constraint.getCreationSQL());
            }
        }
    }

    public static void dropConstraints(PrintWriter writer, PgSchema oldSchema, PgSchema newSchema, boolean primaryKey, SearchPathHelper searchPathHelper) {
        for (PgTable newTable : newSchema.getTables()) {
            PgTable oldTable = oldSchema == null ? null : oldSchema.getTable(newTable.getName());
            for (PgConstraint constraint : PgDiffConstraints.getDropConstraints(oldTable, newTable, primaryKey)) {
                searchPathHelper.outputSearchPath(writer);
                writer.println();
                writer.println(constraint.getDropSQL());
            }
        }
    }

    private static List<PgConstraint> getDropConstraints(PgTable oldTable, PgTable newTable, boolean primaryKey) {
        ArrayList<PgConstraint> list = new ArrayList<PgConstraint>();
        if (newTable != null && oldTable != null) {
            for (PgConstraint constraint : oldTable.getConstraints()) {
                if (constraint.isPrimaryKeyConstraint() != primaryKey || newTable.containsConstraint(constraint.getName()) && newTable.getConstraint(constraint.getName()).equals(constraint)) continue;
                list.add(constraint);
            }
        }
        return list;
    }

    private static List<PgConstraint> getNewConstraints(PgTable oldTable, PgTable newTable, boolean primaryKey) {
        ArrayList<PgConstraint> list;
        block4: {
            list = new ArrayList<PgConstraint>();
            if (newTable == null) break block4;
            if (oldTable == null) {
                for (PgConstraint constraint : newTable.getConstraints()) {
                    if (constraint.isPrimaryKeyConstraint() != primaryKey) continue;
                    list.add(constraint);
                }
            } else {
                for (PgConstraint constraint : newTable.getConstraints()) {
                    if (constraint.isPrimaryKeyConstraint() != primaryKey || oldTable.containsConstraint(constraint.getName()) && oldTable.getConstraint(constraint.getName()).equals(constraint)) continue;
                    list.add(constraint);
                }
            }
        }
        return list;
    }

    public static void alterComments(PrintWriter writer, PgSchema oldSchema, PgSchema newSchema, SearchPathHelper searchPathHelper) {
        if (oldSchema == null) {
            return;
        }
        for (PgTable oldTable : oldSchema.getTables()) {
            PgTable newTable = newSchema.getTable(oldTable.getName());
            if (newTable == null) continue;
            for (PgConstraint oldConstraint : oldTable.getConstraints()) {
                PgConstraint newConstraint = newTable.getConstraint(oldConstraint.getName());
                if (newConstraint == null) continue;
                if (oldConstraint.getComment() == null && newConstraint.getComment() != null || oldConstraint.getComment() != null && newConstraint.getComment() != null && !oldConstraint.getComment().equals(newConstraint.getComment())) {
                    searchPathHelper.outputSearchPath(writer);
                    writer.println();
                    writer.print("COMMENT ON ");
                    if (newConstraint.isPrimaryKeyConstraint()) {
                        writer.print("INDEX ");
                        writer.print(PgDiffUtils.getQuotedName(newConstraint.getName()));
                    } else {
                        writer.print("CONSTRAINT ");
                        writer.print(PgDiffUtils.getQuotedName(newConstraint.getName()));
                        writer.print(" ON ");
                        writer.print(PgDiffUtils.getQuotedName(newConstraint.getTableName()));
                    }
                    writer.print(" IS ");
                    writer.print(newConstraint.getComment());
                    writer.println(';');
                    continue;
                }
                if (oldConstraint.getComment() == null || newConstraint.getComment() != null) continue;
                searchPathHelper.outputSearchPath(writer);
                writer.println();
                writer.print("COMMENT ON ");
                if (newConstraint.isPrimaryKeyConstraint()) {
                    writer.print("INDEX ");
                    writer.print(PgDiffUtils.getQuotedName(newConstraint.getName()));
                } else {
                    writer.print("CONSTRAINT ");
                    writer.print(PgDiffUtils.getQuotedName(newConstraint.getName()));
                    writer.print(" ON ");
                    writer.print(PgDiffUtils.getQuotedName(newConstraint.getTableName()));
                }
                writer.println(" IS NULL;");
            }
        }
    }

    private PgDiffConstraints() {
    }
}

