/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.fluent.tiles;

import com.jgoodies.common.base.Strings;
import com.jgoodies.common.jsdl.internal.CommonFormats;
import com.jgoodies.fluent.tiles.AbstractTile;
import com.jgoodies.fluent.tiles.Tile;
import java.util.function.Function;

public final class ObjectTile
extends AbstractTile {
    public static final String PROPERTY_TITLE = "title";
    public static final String PROPERTY_SUBTITLE = "subtitle";
    public static final String PROPERTY_NUMBER = "number";
    public static final String PROPERTY_NUMBER_UNIT = "numberUnit";
    private String title;
    private String subtitle;
    private String number;
    private String numberUnit;

    public ObjectTile() {
        this.setSize(Tile.Size.WIDE);
        this.setState(AbstractTile.TileState.DEFAULT);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String newValue) {
        this.title = newValue;
        this.firePropertyChange(PROPERTY_TITLE, this.title, this.title);
    }

    public void setTitle(String text, Object ... args) {
        this.setTitle(Strings.get(text, args));
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public void setSubtitle(String newValue) {
        this.subtitle = newValue;
        this.firePropertyChange(PROPERTY_SUBTITLE, this.subtitle, this.subtitle);
    }

    public void setSubtitle(String text, Object ... args) {
        this.setSubtitle(Strings.get(text, args));
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String newValue) {
        this.number = newValue;
        this.firePropertyChange(PROPERTY_NUMBER, this.number, this.number);
    }

    public String getNumberUnit() {
        return this.numberUnit;
    }

    public void setNumberUnit(String newValue) {
        this.numberUnit = newValue;
        this.firePropertyChange(PROPERTY_NUMBER_UNIT, this.numberUnit, this.numberUnit);
    }

    static abstract class AbstractBuilder<B extends AbstractBuilder<?>>
    extends AbstractTile.AbstractBuilder<ObjectTile, B> {
        AbstractBuilder() {
        }

        @Override
        protected ObjectTile createTarget() {
            return new ObjectTile();
        }

        public B title(String str, Object ... args) {
            ((ObjectTile)this.target).setTitle(str, args);
            return (B)this;
        }

        public <T> B title(T object, Function<T, String> formatter) {
            ((ObjectTile)this.target).setTitle(formatter.apply(object));
            return (B)this;
        }

        public B subtitle(String str, Object ... args) {
            ((ObjectTile)this.target).setSubtitle(str, args);
            return (B)this;
        }

        public B subtitleItems(Object ... items) {
            return this.subtitle(CommonFormats.joinWithDots(items), new Object[0]);
        }

        public B subtitleBreadcrumbs(Object ... pathNodes) {
            return this.subtitle(CommonFormats.joinWithSlashes(pathNodes), new Object[0]);
        }

        public B number(String str, Object ... args) {
            ((ObjectTile)this.target).setNumber(Strings.get(str, args));
            return (B)this;
        }

        public <T> B number(T object, Function<T, String> formatter) {
            return this.number(formatter.apply(object), new Object[0]);
        }

        public B number(long value) {
            return this.number(CommonFormats.formatNumber(value), new Object[0]);
        }

        public B numberUnit(String value) {
            ((ObjectTile)this.target).setNumberUnit(value);
            return (B)this;
        }
    }

    public static final class Adder<B>
    extends AbstractBuilder<Adder<B>> {
        private final Function<ObjectTile, B> addFunction;

        public Adder(Function<ObjectTile, B> addFunction) {
            this.addFunction = addFunction;
        }

        public B endTile() {
            return this.addFunction.apply((ObjectTile)this.build());
        }
    }

    public static final class Builder
    extends AbstractBuilder<Builder> {
        @Override
        public ObjectTile build() {
            return (ObjectTile)super.build();
        }
    }
}

