/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.core.style.basic;

import com.jgoodies.common.jsdl.internal.ScaledIconAccess;
import com.jgoodies.common.jsdl.util.ColorUtils;
import com.jgoodies.dialogs.core.CoreDialogResources;
import com.jgoodies.dialogs.core.style.Style;
import java.awt.Color;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;

public abstract class BasicStyle
extends Style {
    protected static final Color WHITE = new ColorUIResource(Color.WHITE);
    protected static final Color LIGHTEST_GRAY = new ColorUIResource(251, 251, 251);
    protected static final Color VERY_LIGHT_GRAY = new ColorUIResource(240, 240, 240);
    protected static final Color LIGHT_GRAY = new ColorUIResource(223, 223, 223);
    protected static final Color GRAY = new ColorUIResource(200, 200, 200);
    protected static final Color TITLE_BLUE = new ColorUIResource(0, 43, 130);

    @Override
    public void install(UIDefaults table) {
        this.initClassDefaults(table);
        this.initComponentDefaults(table);
        this.initLayoutDefaults(table);
    }

    protected void initClassDefaults(UIDefaults table) {
        String prefix = "com.jgoodies.dialogs.core.plaf.basic.Basic";
        Object[] uiDefaults = new Object[]{"JSDL.StyledPaneUI", "com.jgoodies.dialogs.core.plaf.basic.BasicStyledPaneUI", "JSDL.TabbedStyledPaneUI", "com.jgoodies.dialogs.core.plaf.basic.BasicStyledPaneUI", "JSDL.TaskPaneUI", "com.jgoodies.dialogs.core.plaf.basic.BasicTaskPaneUI", "JSDL.FormPaneUI", "com.jgoodies.dialogs.core.plaf.basic.BasicAbstractStyledPaneUI", "JSDL.TabbedFormPaneUI", "com.jgoodies.dialogs.core.plaf.basic.BasicAbstractStyledPaneUI", "JSDL.PropertyPaneUI", "com.jgoodies.dialogs.core.plaf.basic.BasicAbstractStyledPaneUI", "JSDL.TabbedPropertyPaneUI", "com.jgoodies.dialogs.core.plaf.basic.BasicAbstractStyledPaneUI", "JSDL.ListPropertyPaneUI", "com.jgoodies.dialogs.core.plaf.basic.BasicAbstractStyledPaneUI", "JSDL.TreePropertyPaneUI", "com.jgoodies.dialogs.core.plaf.basic.BasicAbstractStyledPaneUI", "JSDL.WizardPaneUI", "com.jgoodies.dialogs.core.plaf.basic.BasicWizardPaneUI"};
        table.putDefaults(uiDefaults);
    }

    protected void initComponentDefaults(UIDefaults table) {
        String collapsedDescription = CoreDialogResources.getString("collapsedIcon");
        Icon collapsedIcon = BasicStyle.getIcon(BasicStyle.class, "icons/collapsed.png", collapsedDescription);
        String expandedDescription = CoreDialogResources.getString("expandedIcon");
        Icon expandedIcon = BasicStyle.getIcon(BasicStyle.class, "icons/expanded.png", expandedDescription);
        Color defaultBackground = table.getColor("Panel.background");
        FontUIResource headerFont = this.getHeaderFont(table);
        FontUIResource mainInstructionFont = this.getMainInstructionFont(table);
        Color controlText = table.getColor("controlText");
        float brightness = ColorUtils.brightness(controlText);
        Color headerForeground = (double)brightness <= 0.21 ? TITLE_BLUE : GRAY;
        Object[] uiDefaults = new Object[]{"StyledPane.background", defaultBackground, "PropertyPane.background", defaultBackground, "TabbedStyledPane.background", defaultBackground, "TabbedPropertyPane.background", defaultBackground, "StyledPane.HeaderArea.enabled", Boolean.FALSE, "StyledPane.HeaderArea.background", defaultBackground, "StyledPane.HeaderArea.separator", GRAY, "StyledPane.CommandArea.enabled", Boolean.TRUE, "StyledPane.CommandArea.background", defaultBackground, "StyledPane.CommandArea.separator", GRAY, "CollapsedControl.icon", collapsedIcon, "CollapsedControl.pressedIcon", collapsedIcon, "CollapsedControl.rolloverIcon", collapsedIcon, "ExpandedControl.icon", expandedIcon, "ExpandedControl.pressedIcon", expandedIcon, "ExpandedControl.rolloverIcon", expandedIcon, "AbstractStyledPane.header.font", headerFont, "AbstractStyledPane.header.foreground", headerForeground, "TaskPane.mainInstruction.font", mainInstructionFont, "TaskPane.mainInstruction.foreground", headerForeground, "WizardPane.mainInstruction.font", mainInstructionFont, "WizardPane.mainInstruction.foreground", headerForeground, "ListPropertyPane.tabTitle.font", headerFont, "ListPropertyPane.tabTitle.foreground", headerForeground, "JSDL.resourceSuffix", ""};
        table.putDefaults(uiDefaults);
    }

    protected void initLayoutDefaults(UIDefaults table) {
        Integer zero = 0;
        Integer three = 3;
        Integer four = 4;
        Integer five = 5;
        Integer six = 6;
        Integer seven = 7;
        Integer eight = 8;
        Integer nine = 9;
        Integer fourteen = 14;
        Integer sixteen = 16;
        Integer twentyOne = 21;
        Integer commandAreaHeightDefault = 25;
        Integer commandAreaHeightSmall = 25;
        Integer commandAreaHeightTall = 30;
        Object[] uiDefaults = new Object[]{"StyledPane.default.margin.pane.left", six, "StyledPane.default.margin.pane.right", five, "StyledPane.default.margin.header.top", eight, "StyledPane.default.margin.header.bottom", zero, "StyledPane.default.margin.content.top", seven, "StyledPane.default.margin.content.bottom", fourteen, "StyledPane.default.commandArea.minHeight", commandAreaHeightDefault, "StyledPane.wide.margin.pane.left", fourteen, "StyledPane.wide.margin.pane.right", fourteen, "StyledPane.wide.margin.header.top", fourteen, "StyledPane.wide.margin.header.bottom", zero, "StyledPane.wide.margin.content.top", seven, "StyledPane.wide.margin.content.bottom", fourteen, "StyledPane.wide.commandArea.minHeight", commandAreaHeightDefault, "TabbedStyledPane.default.margin.pane.left", four, "TabbedStyledPane.default.margin.pane.right", four, "TabbedStyledPane.default.margin.header.top", zero, "TabbedStyledPane.default.margin.header.bottom", zero, "TabbedStyledPane.default.margin.content.top", four, "TabbedStyledPane.default.margin.content.bottom", zero, "TabbedStyledPane.default.commandArea.minHeight", commandAreaHeightSmall, "TabbedStyledPane.wide.margin.pane.left", fourteen, "TabbedStyledPane.wide.margin.pane.right", fourteen, "TabbedStyledPane.wide.margin.header.top", seven, "TabbedStyledPane.wide.margin.header.bottom", zero, "TabbedStyledPane.wide.margin.content.top", fourteen, "TabbedStyledPane.wide.margin.content.bottom", zero, "TabbedStyledPane.wide.commandArea.minHeight", commandAreaHeightSmall, "FormPane.default.margin.pane.left", six, "FormPane.default.margin.pane.right", five, "FormPane.default.margin.header.top", eight, "FormPane.default.margin.header.bottom", zero, "FormPane.default.margin.content.top", seven, "FormPane.default.margin.content.bottom", fourteen, "FormPane.default.commandArea.minHeight", commandAreaHeightDefault, "FormPane.wide.margin.pane.left", fourteen, "FormPane.wide.margin.pane.right", fourteen, "FormPane.wide.margin.header.top", fourteen, "FormPane.wide.margin.header.bottom", zero, "FormPane.wide.margin.content.top", seven, "FormPane.wide.margin.content.bottom", fourteen, "FormPane.wide.commandArea.minHeight", commandAreaHeightDefault, "TabbedFormPane.default.margin.pane.left", four, "TabbedFormPane.default.margin.pane.right", four, "TabbedFormPane.default.margin.header.top", zero, "TabbedFormPane.default.margin.header.bottom", zero, "TabbedFormPane.default.margin.content.top", four, "TabbedFormPane.default.margin.content.bottom", zero, "TabbedFormPane.default.commandArea.minHeight", commandAreaHeightSmall, "TabbedFormPane.wide.margin.pane.left", fourteen, "TabbedFormPane.wide.margin.pane.right", fourteen, "TabbedFormPane.wide.margin.header.top", seven, "TabbedFormPane.wide.margin.header.bottom", zero, "TabbedFormPane.wide.margin.content.top", fourteen, "TabbedFormPane.wide.margin.content.bottom", zero, "TabbedFormPane.wide.commandArea.minHeight", commandAreaHeightSmall, "PropertyPane.default.margin.pane.left", seven, "PropertyPane.default.margin.pane.right", seven, "PropertyPane.default.margin.header.top", zero, "PropertyPane.default.margin.header.bottom", zero, "PropertyPane.default.margin.content.top", seven, "PropertyPane.default.margin.content.bottom", nine, "PropertyPane.default.commandArea.minHeight", commandAreaHeightDefault, "PropertyPane.wide.margin.pane.left", fourteen, "PropertyPane.wide.margin.pane.right", fourteen, "PropertyPane.wide.margin.header.top", zero, "PropertyPane.wide.margin.header.bottom", zero, "PropertyPane.wide.margin.content.top", fourteen, "PropertyPane.wide.margin.content.bottom", sixteen, "PropertyPane.wide.commandArea.minHeight", commandAreaHeightDefault, "TabbedPropertyPane.default.margin.pane.left", four, "TabbedPropertyPane.default.margin.pane.right", four, "TabbedPropertyPane.default.margin.header.top", zero, "TabbedPropertyPane.default.margin.header.bottom", zero, "TabbedPropertyPane.default.margin.content.top", four, "TabbedPropertyPane.default.margin.content.bottom", zero, "TabbedPropertyPane.default.commandArea.minHeight", commandAreaHeightSmall, "TabbedPropertyPane.wide.margin.pane.left", fourteen, "TabbedPropertyPane.wide.margin.pane.right", fourteen, "TabbedPropertyPane.wide.margin.header.top", seven, "TabbedPropertyPane.wide.margin.header.bottom", zero, "TabbedPropertyPane.wide.margin.content.top", fourteen, "TabbedPropertyPane.wide.margin.content.bottom", zero, "TabbedPropertyPane.wide.commandArea.minHeight", commandAreaHeightSmall, "ListPropertyPane.default.margin.pane.left", fourteen, "ListPropertyPane.default.margin.pane.right", fourteen, "ListPropertyPane.default.margin.header.top", zero, "ListPropertyPane.default.margin.header.bottom", zero, "ListPropertyPane.default.margin.content.top", fourteen, "ListPropertyPane.default.margin.content.bottom", sixteen, "ListPropertyPane.default.commandArea.minHeight", commandAreaHeightTall, "ListPropertyPane.default.gap.listTabs", fourteen, "ListPropertyPane.default.gap.titleTabs", six, "TaskPane.default.margin.pane.left", six, "TaskPane.default.margin.pane.right", five, "TaskPane.default.margin.header.top", eight, "TaskPane.default.margin.header.bottom", zero, "TaskPane.default.margin.content.top", four, "TaskPane.default.margin.content.bottom", fourteen, "TaskPane.default.commandArea.minHeight", commandAreaHeightDefault, "TaskPane.default.gap.mainInstruction.iconText", six, "TaskPane.default.margin.contentText.bottom", three, "TaskPane.default.margin.contentExpansion.top", three, "TaskPane.default.margin.contentExpansion.bottom", three, "TaskPane.default.margin.progress.top", three, "TaskPane.default.margin.progress.bottom", three, "TaskPane.default.margin.radioButtons.top", three, "TaskPane.default.margin.radioButtons.bottom", three, "TaskPane.default.margin.commandLinks.top", three, "TaskPane.wide.margin.pane.left", fourteen, "TaskPane.wide.margin.pane.right", fourteen, "TaskPane.wide.margin.header.top", fourteen, "TaskPane.wide.margin.header.bottom", zero, "TaskPane.wide.margin.content.top", seven, "TaskPane.wide.margin.content.bottom", twentyOne, "TaskPane.wide.commandArea.minHeight", commandAreaHeightTall, "TaskPane.wide.gap.mainInstruction.iconText", six, "TaskPane.wide.margin.contentText.bottom", three, "TaskPane.wide.margin.contentExpansion.top", three, "TaskPane.wide.margin.contentExpansion.bottom", three, "TaskPane.wide.margin.progress.top", three, "TaskPane.wide.margin.progress.bottom", three, "TaskPane.wide.margin.radioButtons.top", three, "TaskPane.wide.margin.radioButtons.bottom", three, "TaskPane.wide.margin.commandLinks.top", three, "WizardPane.default.margin.pane.left", fourteen, "WizardPane.default.margin.pane.right", fourteen, "WizardPane.default.margin.header.top", nine, "WizardPane.default.margin.header.bottom", zero, "WizardPane.default.gap.mainInstruction.iconText", six, "WizardPane.default.margin.content.top", four, "WizardPane.default.margin.content.bottom", fourteen, "WizardPane.default.commandArea.minHeight", commandAreaHeightDefault, "WizardPane.default.indent.content.left", 12, "WizardPane.wide.margin.pane.left", twentyOne, "WizardPane.wide.margin.pane.right", fourteen, "WizardPane.wide.margin.header.top", fourteen, "WizardPane.wide.margin.header.bottom", zero, "WizardPane.wide.margin.content.top", seven, "WizardPane.wide.margin.content.bottom", twentyOne, "WizardPane.wide.commandArea.minHeight", commandAreaHeightTall};
        table.putDefaults(uiDefaults);
    }

    protected Font getControlFont(UIDefaults table) {
        return table.getFont("Button.font");
    }

    protected FontUIResource getHeaderFont(UIDefaults table) {
        Font controlFont = this.getControlFont(table);
        float controlFontSize = controlFont.getSize2D();
        int style = 0;
        Font largerFont = controlFont.deriveFont(style, controlFontSize * 1.33344f);
        return new FontUIResource(largerFont);
    }

    protected FontUIResource getMainInstructionFont(UIDefaults table) {
        return this.getHeaderFont(table);
    }

    protected FontUIResource getPropertyCardTitleFont(UIDefaults table) {
        return this.getHeaderFont(table);
    }

    protected final Icon getIcon(String filename, String description) {
        return ScaledIconAccess.getIcon(this.getClass(), filename, description, null);
    }

    protected static Icon getIcon(Class<?> clazz, String filename, String description) {
        return ScaledIconAccess.getIcon(clazz, filename, description, null);
    }
}

