/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.components.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JScrollPane;

public final class ComponentTreeUtils {
    private ComponentTreeUtils() {
    }

    public static void updateAllUIs() {
        Frame[] frames;
        Logger.getLogger(ComponentTreeUtils.class.getName()).info("Updating all UIs.");
        for (Frame element : frames = Frame.getFrames()) {
            Window[] windows;
            ComponentTreeUtils.updateComponentTreeUI(element);
            for (Window element2 : windows = element.getOwnedWindows()) {
                ComponentTreeUtils.updateComponentTreeUI(element2);
            }
        }
    }

    public static void updateComponentTreeUI(Component c) {
        ComponentTreeUtils.updateComponentTreeUI0(c);
        c.invalidate();
        c.validate();
        c.repaint();
    }

    private static void updateComponentTreeUI0(Component c) {
        if (c instanceof JScrollPane) {
            ((JComponent)c).updateUI();
        }
        Component[] children = null;
        if (c instanceof JMenu) {
            children = ((JMenu)c).getMenuComponents();
        } else if (c instanceof Container) {
            children = ((Container)c).getComponents();
        }
        if (children != null) {
            for (Component element : children) {
                ComponentTreeUtils.updateComponentTreeUI0(element);
            }
        }
        if (c instanceof JComponent && !(c instanceof JScrollPane)) {
            ((JComponent)c).updateUI();
        }
    }
}

