/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.binder;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.binder.BinderUtils;
import com.jgoodies.binding.binder.SelectionInListBindingBuilder;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.common.base.Preconditions;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;

public class SelectionInListBindingBuilderImpl<E>
implements SelectionInListBindingBuilder<E> {
    private final SelectionInList<E> selectionInList;
    private final String propertyName;

    public SelectionInListBindingBuilderImpl(SelectionInList<E> selectionInList) {
        this(selectionInList, null);
    }

    public SelectionInListBindingBuilderImpl(SelectionInList<E> selectionInList, String propertyName) {
        this.selectionInList = Preconditions.checkNotNull(selectionInList, "The %s must not be null.", "SelectionInList");
        this.propertyName = propertyName;
        if (propertyName != null) {
            Preconditions.checkNotBlank(propertyName, "The %s must not be null, empty, or whitespace.", "bean property name");
        }
    }

    @Override
    public void to(JComboBox<E> comboBox) {
        Bindings.bind(comboBox, this.selectionInList);
        this.setValidationMessageKey(comboBox);
    }

    @Override
    public void to(JComboBox<E> comboBox, String nullText) {
        Bindings.bind(comboBox, this.selectionInList, nullText);
        this.setValidationMessageKey(comboBox);
    }

    @Override
    public void to(JList<E> list) {
        Bindings.bind(list, this.selectionInList);
    }

    @Override
    public void to(JTable table) {
        Bindings.bind(table, this.selectionInList);
    }

    protected final SelectionInList<E> getSelectionInList() {
        return this.selectionInList;
    }

    protected final String getPropertyName() {
        return this.propertyName;
    }

    protected final void setValidationMessageKey(JComponent comp) {
        if (this.getPropertyName() != null) {
            BinderUtils.setValidationMessageKey(comp, this.getPropertyName());
        }
    }
}

